/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.version.FrozenNodeInitializer;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionStorageDescendantNode;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionHistoryImpl
extends VersionStorageDescendantNode
implements VersionHistory {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl");

    public VersionHistoryImpl(NodeData data, SessionImpl session) throws PathNotFoundException, RepositoryException {
        super(data, session);
        if (!this.isNodeType(Constants.NT_VERSIONHISTORY)) {
            throw new RepositoryException("Node " + this.getLocation().getAsString(true) + " is not nt:versionHistory type");
        }
    }

    @Override
    public void loadData(ItemData vhData, NodeData parent) throws RepositoryException, InvalidItemStateException, ConstraintViolationException {
        super.loadData(new VersionHistoryDataHelper((NodeData)vhData, this.session.getTransientNodesManager().getTransactManager(), this.session.getWorkspace().getNodeTypesHolder()), parent);
    }

    @Override
    public VersionHistoryDataHelper getData() {
        return (VersionHistoryDataHelper)super.getData();
    }

    public String getVersionableUUID() throws RepositoryException {
        this.checkValid();
        PropertyData versionableUuid = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_VERSIONABLEUUID, 0), ItemType.PROPERTY);
        if (versionableUuid != null) {
            try {
                return ValueDataUtil.getString(versionableUuid.getValues().get(0));
            }
            catch (IllegalStateException e) {
                LOG.error((Object)("jcr:versionableUuid, error of read " + e + ". Version history " + this.getPath()), (Throwable)e);
            }
        }
        throw new ItemNotFoundException("A property jcr:versionableUuid is not found. Version history " + this.getPath());
    }

    public Version getRootVersion() throws RepositoryException {
        this.checkValid();
        VersionImpl version = (VersionImpl)this.dataManager.getItem(this.nodeData(), new QPathEntry(Constants.JCR_ROOTVERSION, 0), true, ItemType.NODE);
        if (version == null) {
            throw new VersionException("There are no root version in the version history " + this.getPath());
        }
        return version;
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        this.checkValid();
        List<NodeData> versionsDataList = this.getData().getAllVersionsData();
        EntityCollection versions = new EntityCollection();
        for (NodeData vd : versionsDataList) {
            versions.add(new VersionImpl(vd, this.session));
        }
        return versions;
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        this.checkValid();
        return this.version(versionName, true);
    }

    public Version version(String versionName, boolean pool) throws VersionException, RepositoryException {
        JCRName jcrVersionName = this.locationFactory.parseJCRName(versionName);
        VersionImpl version = (VersionImpl)this.dataManager.getItem(this.nodeData(), new QPathEntry(jcrVersionName.getInternalName(), 1), pool, ItemType.NODE, false);
        if (version == null) {
            throw new VersionException("There are no version with name '" + versionName + "' in the version history " + this.getPath());
        }
        return version;
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        this.checkValid();
        NodeData versionData = this.getVersionDataByLabel(label);
        if (versionData == null) {
            throw new RepositoryException("There are no label '" + label + "' in the version history " + this.getPath());
        }
        VersionImpl version = (VersionImpl)this.dataManager.getItemByIdentifier(versionData.getIdentifier(), true, false);
        if (version == null) {
            throw new VersionException("There are no version with label '" + label + "' in the version history " + this.getPath());
        }
        return version;
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        this.checkValid();
        return this.getVersionDataByLabel(label) != null;
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        this.checkValid();
        NodeData versionData = this.getVersionDataByLabel(label);
        return versionData != null && version.getUUID().equals(versionData.getIdentifier());
    }

    public String[] getVersionLabels() throws RepositoryException {
        this.checkValid();
        List<PropertyData> versionLabels = this.getData().getVersionLabels();
        String[] labelsStrs = new String[versionLabels.size()];
        for (int i = 0; i < versionLabels.size(); ++i) {
            labelsStrs[i] = this.locationFactory.createJCRName(versionLabels.get(i).getQPath().getName()).getAsString();
        }
        return labelsStrs;
    }

    protected List<String> getVersionLabelsList(Version version) throws VersionException, RepositoryException {
        if (!this.isVersionBelongToThis(version)) {
            throw new VersionException("There are no version '" + version.getPath() + "' in the version history " + this.getPath());
        }
        List<PropertyData> labelsList = this.getData().getVersionLabels();
        ArrayList<String> vlabels = new ArrayList<String>();
        for (PropertyData prop : labelsList) {
            String versionUuid = ValueDataUtil.getString(prop.getValues().get(0));
            if (!versionUuid.equals(((VersionImpl)version).getInternalIdentifier())) continue;
            vlabels.add(this.locationFactory.createJCRName(prop.getQPath().getName()).getAsString());
        }
        return vlabels;
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        this.checkValid();
        List<String> vlabels = this.getVersionLabelsList(version);
        String[] res = new String[vlabels.size()];
        for (int i = 0; i < vlabels.size(); ++i) {
            res[i] = vlabels.get(i);
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeVersion(String versionName) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        PropertyData predecessorsData;
        PlainChangesLogImpl changes;
        PropertyData baseVersion;
        Object versionableUuidProp;
        this.checkValid();
        VersionImpl version = (VersionImpl)this.version(versionName, true);
        List<PropertyData> refs = this.dataManager.getReferencesData(version.getInternalIdentifier(), true);
        if (refs.size() == 2 && (refs.get(0).getQPath().getName().equals((Object)Constants.JCR_BASEVERSION) && refs.get(1).getQPath().getName().equals((Object)Constants.JCR_PREDECESSORS) || refs.get(0).getQPath().getName().equals((Object)Constants.JCR_PREDECESSORS) && refs.get(1).getQPath().getName().equals((Object)Constants.JCR_BASEVERSION))) {
            versionableUuidProp = (PropertyData)this.dataManager.getItemData((NodeData)version.getParent().getData(), new QPathEntry(Constants.JCR_VERSIONABLEUUID, 1), ItemType.PROPERTY);
            NodeData nodeData = (NodeData)this.dataManager.getItemData(ValueDataUtil.getString(versionableUuidProp.getValues().get(0)));
            baseVersion = (PropertyData)this.dataManager.getItemData(nodeData, new QPathEntry(Constants.JCR_BASEVERSION, 0), ItemType.PROPERTY);
            if (!version.getIdentifier().equals(ValueDataUtil.getString(baseVersion.getValues().get(0))) || Constants.JCR_ROOTVERSION.equals((Object)version.getInternalName())) throw new ReferentialIntegrityException("There are Reference property pointed to this Version " + refs.get(0).getQPath().getAsString());
            PropertyData predecessorsVersion = (PropertyData)this.dataManager.getItemData(nodeData, new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
            changes = new PlainChangesLogImpl(this.session);
            predecessorsData = (PropertyData)this.dataManager.getItemData((NodeData)version.getData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
            ValueData pvalue = predecessorsData.getValues().get(0);
            TransientPropertyData newBaseProp = new TransientPropertyData(baseVersion.getQPath(), baseVersion.getIdentifier(), baseVersion.getPersistedVersion(), baseVersion.getType(), baseVersion.getParentIdentifier(), baseVersion.isMultiValued(), pvalue);
            changes.add(ItemState.createUpdatedState(newBaseProp));
            TransientPropertyData newPredecessorsVersion = new TransientPropertyData(predecessorsVersion.getQPath(), predecessorsVersion.getIdentifier(), predecessorsVersion.getPersistedVersion(), predecessorsVersion.getType(), predecessorsVersion.getParentIdentifier(), predecessorsVersion.isMultiValued(), pvalue);
            changes.add(ItemState.createUpdatedState(newPredecessorsVersion));
        } else if (refs.size() == 1 && refs.get(0).getQPath().getName().equals((Object)Constants.JCR_BASEVERSION)) {
            versionableUuidProp = (PropertyData)this.dataManager.getItemData((NodeData)version.getParent().getData(), new QPathEntry(Constants.JCR_VERSIONABLEUUID, 1), ItemType.PROPERTY);
            NodeData nodeData = (NodeData)this.dataManager.getItemData(ValueDataUtil.getString(versionableUuidProp.getValues().get(0)));
            baseVersion = (PropertyData)this.dataManager.getItemData(nodeData, new QPathEntry(Constants.JCR_BASEVERSION, 0), ItemType.PROPERTY);
            if (!version.getIdentifier().equals(ValueDataUtil.getString(baseVersion.getValues().get(0))) || Constants.JCR_ROOTVERSION.equals((Object)version.getInternalName())) throw new ReferentialIntegrityException("There are Reference property pointed to this Version " + refs.get(0).getQPath().getAsString());
            changes = new PlainChangesLogImpl(this.session);
            predecessorsData = (PropertyData)this.dataManager.getItemData((NodeData)version.getData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
            ValueData pvalue = predecessorsData.getValues().get(0);
            TransientPropertyData newBaseProp = new TransientPropertyData(baseVersion.getQPath(), baseVersion.getIdentifier(), baseVersion.getPersistedVersion(), baseVersion.getType(), baseVersion.getParentIdentifier(), baseVersion.isMultiValued(), pvalue);
            changes.add(ItemState.createUpdatedState(newBaseProp));
        } else {
            if (refs.size() > 0) {
                throw new ReferentialIntegrityException("There are Reference property pointed to this Version " + refs.get(0).getQPath().getAsString());
            }
            changes = new PlainChangesLogImpl(this.session);
        }
        for (PropertyData propertyData : this.getData().getVersionLabels()) {
            String versionUuid = ValueDataUtil.getString(propertyData.getValues().get(0));
            if (!versionUuid.equals(version.getInternalIdentifier())) continue;
            changes.add(ItemState.createDeletedState(propertyData));
        }
        PropertyData successorsData = (PropertyData)this.dataManager.getItemData((NodeData)version.getData(), new QPathEntry(Constants.JCR_SUCCESSORS, 0), ItemType.PROPERTY);
        predecessorsData = (PropertyData)this.dataManager.getItemData((NodeData)version.getData(), new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY);
        for (ValueData pvalue : predecessorsData.getValues()) {
            String pidentifier = ValueDataUtil.getString(pvalue);
            VersionImpl predecessor = (VersionImpl)this.dataManager.getItemByIdentifier(pidentifier, false, false);
            if (predecessor == null) throw new RepositoryException("A predecessor (" + pidentifier + ") of the version " + version.getPath() + " is not found.");
            if (successorsData != null) {
                for (ValueData svalue : successorsData.getValues()) {
                    predecessor.removeAddSuccessor(version.getInternalIdentifier(), ValueDataUtil.getString(svalue), changes);
                }
                continue;
            }
            predecessor.removeSuccessor(version.getInternalIdentifier(), changes);
        }
        if (successorsData != null) {
            for (ValueData svalue : successorsData.getValues()) {
                String sidentifier = ValueDataUtil.getString(svalue);
                VersionImpl successor = (VersionImpl)this.dataManager.getItemByIdentifier(sidentifier, false, false);
                if (successor == null) throw new RepositoryException("A successor (" + sidentifier + ") of the version " + version.getPath() + " is not found.");
                for (ValueData pvalue : predecessorsData.getValues()) {
                    successor.removeAddPredecessor(version.getInternalIdentifier(), ValueDataUtil.getString(pvalue), changes);
                }
            }
        }
        ItemDataRemoveVisitor itemDataRemoveVisitor = new ItemDataRemoveVisitor((ItemDataConsumer)this.dataManager.getTransactManager(), null);
        version.getData().accept(itemDataRemoveVisitor);
        changes.addAll(itemDataRemoveVisitor.getRemovedStates());
        this.dataManager.getTransactManager().save(changes);
        version.invalidate();
    }

    protected NodeData getVersionData(String versionName) throws VersionException, RepositoryException {
        JCRPath jcrPath = this.locationFactory.createJCRPath(this.getLocation(), versionName);
        NodeData version = this.getData().getVersionData(jcrPath.getName().getInternalName());
        if (version == null) {
            throw new VersionException("Version is not found " + jcrPath.getAsString(false));
        }
        return version;
    }

    protected NodeData getVersionLabelsData() throws VersionException, RepositoryException {
        NodeData labels = this.getData().getVersionLabelsData();
        if (labels == null) {
            throw new VersionException("Mandatory node jcr:versionLabels is not found for version history " + this.getPath());
        }
        return labels;
    }

    protected NodeData getVersionDataByLabel(String labelName) throws VersionException, RepositoryException {
        JCRName jcrLabelName = this.locationFactory.parseJCRName(labelName);
        InternalQName labelQName = jcrLabelName.getInternalName();
        return this.getData().getVersionDataByLabel(labelQName);
    }

    protected NodeData getVersionDataByIdentifier(String versionIdentifier) throws VersionException, RepositoryException {
        NodeData version = (NodeData)this.dataManager.getItemData(versionIdentifier);
        if (version == null) {
            throw new VersionException("Version is not found, uuid: " + versionIdentifier);
        }
        return version;
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws VersionException, RepositoryException {
        this.checkValid();
        JCRName jcrLabelName = this.locationFactory.parseJCRName(label);
        InternalQName labelQName = jcrLabelName.getInternalName();
        NodeData labels = this.getVersionLabelsData();
        List<PropertyData> labelsList = this.dataManager.getChildPropertiesData(labels);
        for (PropertyData prop : labelsList) {
            if (!prop.getQPath().getName().equals((Object)labelQName)) continue;
            if (moveLabel) {
                this.removeVersionLabel(label);
                break;
            }
            throw new VersionException("Label " + label + " is already exists and moveLabel=false");
        }
        NodeData versionData = this.getVersionData(versionName);
        SessionChangesLog changesLog = new SessionChangesLog(this.session);
        TransientPropertyData labelData = TransientPropertyData.createPropertyData(labels, labelQName, 9, false, new TransientValueData(versionData.getIdentifier()));
        changesLog.add(ItemState.createAddedState(labelData));
        this.dataManager.getTransactManager().save(changesLog);
    }

    public void removeVersionLabel(String labelName) throws VersionException, RepositoryException {
        this.checkValid();
        JCRName jcrLabelName = this.locationFactory.parseJCRName(labelName);
        InternalQName labelQName = jcrLabelName.getInternalName();
        PropertyData vldata = (PropertyData)this.dataManager.getItemData(this.getData().getVersionLabelsData(), new QPathEntry(labelQName, 0), ItemType.PROPERTY);
        if (vldata == null) {
            throw new VersionException("Label not found " + labelName);
        }
        PlainChangesLogImpl changes = new PlainChangesLogImpl(this.session);
        changes.add(ItemState.createDeletedState(vldata));
        this.dataManager.getTransactManager().save(changes);
    }

    public void addVersion(NodeData versionableNodeData, String uuid, SessionChangesLog changesLog) throws RepositoryException {
        this.checkValid();
        NodeTypeDataManager ntManager = this.session.getWorkspace().getNodeTypesHolder();
        boolean isPrivilegeable = ntManager.isNodeType(Constants.EXO_PRIVILEGEABLE, versionableNodeData.getPrimaryTypeName(), versionableNodeData.getMixinTypeNames());
        boolean isOwneable = ntManager.isNodeType(Constants.EXO_OWNEABLE, versionableNodeData.getPrimaryTypeName(), versionableNodeData.getMixinTypeNames());
        ArrayList<InternalQName> mixinsList = new ArrayList<InternalQName>();
        mixinsList.add(Constants.MIX_REFERENCEABLE);
        HashSet<AccessControlEntry> accessList = new HashSet<AccessControlEntry>();
        accessList.addAll(this.nodeData().getACL().getPermissionEntries());
        String owner = this.nodeData().getACL().getOwner();
        if (isPrivilegeable) {
            accessList.addAll(versionableNodeData.getACL().getPermissionEntries());
            mixinsList.add(Constants.EXO_PRIVILEGEABLE);
        }
        if (isOwneable) {
            owner = versionableNodeData.getACL().getOwner();
            mixinsList.add(Constants.EXO_OWNEABLE);
        }
        AccessControlList acl = new AccessControlList(owner, new ArrayList<AccessControlEntry>(accessList));
        InternalQName[] mixins = mixinsList.toArray(new InternalQName[mixinsList.size()]);
        TransientNodeData versionData = TransientNodeData.createNodeData(this.nodeData(), new InternalQName(null, this.nextVersionName()), Constants.NT_VERSION, mixins, uuid, acl);
        changesLog.add(ItemState.createAddedState(versionData));
        TransientPropertyData propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_VERSION));
        changesLog.add(ItemState.createAddedState(propData));
        ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
        for (InternalQName internalQName : mixins) {
            mixValues.add(new TransientValueData(internalQName));
        }
        TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_MIXINTYPES, 7, true, mixValues);
        changesLog.add(ItemState.createAddedState(exoMixinTypes));
        if (isOwneable) {
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            changesLog.add(ItemState.createAddedState(exoOwner));
        }
        if (isPrivilegeable) {
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (AccessControlEntry accessControlEntry : acl.getPermissionEntries()) {
                permsValues.add(new TransientValueData(accessControlEntry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoPerms));
        }
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_UUID, 1, false, new TransientValueData(uuid));
        changesLog.add(ItemState.createAddedState(propData));
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_CREATED, 5, false, new TransientValueData(this.session.getTransientNodesManager().getWorkspaceDataManager().getCurrentTime()));
        changesLog.add(ItemState.createAddedState(propData));
        List<ValueData> predecessors = ((PropertyData)this.dataManager.getItemData(versionableNodeData, new QPathEntry(Constants.JCR_PREDECESSORS, 0), ItemType.PROPERTY)).getValues();
        ArrayList<ValueData> predecessorsNew = new ArrayList<ValueData>();
        for (ValueData predecessorValue : predecessors) {
            VersionImpl predecessor = (VersionImpl)this.dataManager.getItemByIdentifier(ValueDataUtil.getString(predecessorValue), false, false);
            predecessor.addSuccessor(versionData.getIdentifier(), changesLog);
            try {
                predecessorsNew.add(ValueDataUtil.createTransientCopy(predecessorValue));
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }
        propData = TransientPropertyData.createPropertyData((NodeData)versionData, Constants.JCR_PREDECESSORS, 9, true, predecessorsNew);
        changesLog.add(ItemState.createAddedState(propData));
        TransientNodeData transientNodeData = TransientNodeData.createNodeData(versionData, Constants.JCR_FROZENNODE, Constants.NT_FROZENNODE);
        changesLog.add(ItemState.createAddedState(transientNodeData));
        propData = TransientPropertyData.createPropertyData((NodeData)transientNodeData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_FROZENNODE));
        changesLog.add(ItemState.createAddedState(propData));
        propData = TransientPropertyData.createPropertyData((NodeData)transientNodeData, Constants.JCR_MIXINTYPES, 7, true, new TransientValueData(Constants.MIX_REFERENCEABLE));
        changesLog.add(ItemState.createAddedState(propData));
        propData = TransientPropertyData.createPropertyData((NodeData)transientNodeData, Constants.JCR_UUID, 1, false, new TransientValueData(transientNodeData.getIdentifier()));
        changesLog.add(ItemState.createAddedState(propData));
        FrozenNodeInitializer visitor = new FrozenNodeInitializer(transientNodeData, this.session.getTransientNodesManager(), this.session.getWorkspace().getNodeTypesHolder(), changesLog, this.session.getValueFactory());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Before frozen visitor: " + changesLog.dump()));
        }
        versionableNodeData.accept(visitor);
    }

    public boolean isVersionBelongToThis(Version version) throws RepositoryException {
        return ((VersionImpl)version).getLocation().isDescendantOf(this.getLocation(), false);
    }

    private String nextVersionName() throws RepositoryException {
        int vn = 0;
        VersionIterator allVersions = this.getAllVersions();
        while (allVersions.hasNext()) {
            Version v = allVersions.nextVersion();
            try {
                int vi = Integer.parseInt(v.getName());
                if (vi <= vn) continue;
                vn = vi;
            }
            catch (NumberFormatException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return vn > 0 ? String.valueOf(vn + 1) : "1";
    }
}

