/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimpleChangedSizeHandler;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class EarlierVersionsRemover
extends AbstractInconsistencyRepair {
    public EarlierVersionsRemover(WorkspaceStorageConnectionFactory connFactory, JDBCDataContainerConfig containerConfig) {
        super(connFactory, containerConfig);
    }

    @Override
    protected void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            PropertyData data = (PropertyData)conn.getItemData(this.getIdentifier(resultSet, "ID"));
            int maxVersion = conn.getMaxPropertyVersion(data);
            if (resultSet.getInt("VERSION") < maxVersion) {
                conn.delete(data, new SimpleChangedSizeHandler());
            }
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }
}

