/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeTraversingQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;

public class ChildNodesQueryHits
extends AbstractQueryHits {
    private final QueryHits parents;
    private final SessionImpl session;
    private QueryHits childHits;
    private IndexingConfiguration indexConfig;

    public ChildNodesQueryHits(QueryHits parents, SessionImpl session, IndexingConfiguration indexConfig) throws IOException {
        this.parents = parents;
        this.session = session;
        this.indexConfig = indexConfig;
        this.fetchNextChildHits();
    }

    @Override
    public void close() throws IOException {
        if (this.childHits != null) {
            this.childHits.close();
        }
        this.parents.close();
    }

    @Override
    public ScoreNode nextScoreNode() throws IOException {
        while (this.childHits != null) {
            ScoreNode sn = this.childHits.nextScoreNode();
            if (sn != null) {
                return sn;
            }
            this.fetchNextChildHits();
        }
        return null;
    }

    private void fetchNextChildHits() throws IOException {
        ScoreNode nextParent;
        if (this.childHits != null) {
            this.childHits.close();
        }
        if ((nextParent = this.parents.nextScoreNode()) != null) {
            try {
                Node parent = (Node)this.session.getTransientNodesManager().getItemByIdentifier(nextParent.getNodeId(), true);
                this.childHits = new NodeTraversingQueryHits(parent, false, 1, this.indexConfig);
            }
            catch (RepositoryException e) {
                throw Util.createIOException(e);
            }
        } else {
            this.childHits = null;
        }
    }
}

