/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.utils;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.utils.DataURIScheme;
import org.apache.tika.parser.utils.DataURISchemeParseException;

public class DataURISchemeUtil {
    public static String UNSPECIFIED_MEDIA_TYPE = "text/plain;charset=US-ASCII";
    private static Pattern PARSE_PATTERN = Pattern.compile("(?s)data:([^,]*?)(base64)?,(.*)$");
    private static Pattern EXTRACT_PATTERN = Pattern.compile("(?s)data:([^,]*?)(base64)?,([^\"']*)[\"']");
    private final Matcher parseMatcher = PARSE_PATTERN.matcher("");
    private final Matcher extractMatcher = EXTRACT_PATTERN.matcher("");
    Base64 base64 = new Base64();

    public DataURIScheme parse(String string) throws DataURISchemeParseException {
        this.parseMatcher.reset(string);
        if (this.parseMatcher.find()) {
            return this.build(this.parseMatcher.group(1), this.parseMatcher.group(2), this.parseMatcher.group(3));
        }
        throw new DataURISchemeParseException("Couldn't find expected pattern");
    }

    private DataURIScheme build(String mediaTypeString, String isBase64, String dataString) {
        byte[] data = null;
        String string = dataString = dataString != null ? dataString.replaceAll("\\\\", " ") : dataString;
        if (dataString == null || dataString.length() == 0) {
            data = new byte[]{};
        } else if (isBase64 != null) {
            data = this.base64.decode(dataString);
        } else {
            String charsetName;
            MediaType mediaType = MediaType.parse((String)mediaTypeString);
            Charset charset = StandardCharsets.UTF_8;
            if (mediaType.hasParameters() && (charsetName = (String)mediaType.getParameters().get("charset")) != null && Charset.isSupported(charsetName)) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    // empty catch block
                }
            }
            data = dataString.getBytes(charset);
        }
        return new DataURIScheme(mediaTypeString, isBase64 != null, data);
    }

    public List<DataURIScheme> extract(String string) {
        this.extractMatcher.reset(string);
        ArrayList<DataURIScheme> list = null;
        while (this.extractMatcher.find()) {
            DataURIScheme dataURIScheme = this.build(this.extractMatcher.group(1), this.extractMatcher.group(2), this.extractMatcher.group(3));
            if (list == null) {
                list = new ArrayList<DataURIScheme>();
            }
            list.add(dataURIScheme);
        }
        return list == null ? Collections.EMPTY_LIST : list;
    }
}

