/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;

public class POSEvaluator
extends Evaluator<POSSample> {
    private POSTagger tagger;
    private Mean wordAccuracy = new Mean();

    public POSEvaluator(POSTagger tagger, POSTaggerEvaluationMonitor ... listeners) {
        super(listeners);
        this.tagger = tagger;
    }

    @Override
    protected POSSample processSample(POSSample reference) {
        String[] predictedTags = this.tagger.tag(reference.getSentence(), (Object[])reference.getAddictionalContext());
        String[] referenceTags = reference.getTags();
        for (int i = 0; i < referenceTags.length; ++i) {
            if (referenceTags[i].equals(predictedTags[i])) {
                this.wordAccuracy.add(1.0);
                continue;
            }
            this.wordAccuracy.add(0.0);
        }
        return new POSSample(reference.getSentence(), predictedTags);
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }

    public String toString() {
        return "Accuracy:" + this.wordAccuracy.mean() + " Number of Samples: " + this.wordAccuracy.count();
    }
}

