/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueLockSupport;

public class ValueDataResourceHolder {
    protected final Map<Object, VDResource> resources = new ConcurrentHashMap<Object, VDResource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aquire(Object resource, ValueLockSupport lockHolder) throws InterruptedException, IOException {
        Thread myThread = Thread.currentThread();
        VDResource res = this.resources.get(resource);
        if (res != null) {
            if (res.addUserLock(myThread, lockHolder)) {
                return false;
            }
            Object object = res.lock;
            synchronized (object) {
                res.lock.wait();
                this.resources.put(resource, new VDResource(myThread, res.lock, lockHolder));
            }
        } else {
            this.resources.put(resource, new VDResource(myThread, new Object(), lockHolder));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Object resource) throws IOException {
        Thread myThread = Thread.currentThread();
        VDResource res = this.resources.get(resource);
        if (res != null && res.removeUserLock(myThread)) {
            Object object = res.lock;
            synchronized (object) {
                res.lockSupport.unlock();
                res.lock.notify();
                this.resources.remove(resource);
            }
            return true;
        }
        return false;
    }

    class VDResource {
        final Thread user;
        final Object lock;
        final ValueLockSupport lockSupport;
        int userLocks = 0;

        VDResource(Thread user, Object lock, ValueLockSupport lockSupport) throws IOException {
            this.user = user;
            this.lock = lock;
            this.lockSupport = lockSupport;
            lockSupport.lock();
            this.userLocks = 1;
        }

        boolean addUserLock(Thread user, ValueLockSupport lockSupport) throws IOException {
            if (this.user.equals(user)) {
                lockSupport.share(this.lockSupport);
                ++this.userLocks;
                return true;
            }
            return false;
        }

        boolean removeUserLock(Thread user) {
            if (this.user.equals(user)) {
                --this.userLocks;
                return this.userLocks <= 0;
            }
            return false;
        }
    }
}

