/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.FilterNode;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.geoapi.filter.LogicalOperator;
import org.apache.sis.internal.geoapi.filter.LogicalOperatorName;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

abstract class LogicalFilter<R>
extends FilterNode<R>
implements LogicalOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 3696645262873257479L;
    protected final Filter<? super R>[] operands;

    LogicalFilter(Collection<? extends Filter<? super R>> collection) {
        ArgumentChecks.ensureNonEmpty((String)"operands", collection);
        this.operands = collection.toArray(new Filter[collection.size()]);
        if (this.operands.length < 2) {
            throw new IllegalArgumentException(Errors.format((short)127, (Object)2, (Object)this.operands.length));
        }
        for (int i = 0; i < this.operands.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"operands", (int)i, this.operands[i]);
        }
    }

    LogicalFilter(Filter<? super R> filter, Filter<? super R> filter2) {
        this.operands = new Filter[]{filter, filter2};
    }

    protected abstract LogicalFilter<R> createSameType(Collection<? extends Filter<? super R>> var1);

    @Override
    public final List<Filter<? super R>> getOperands() {
        return UnmodifiableArrayList.wrap((Object[])this.operands);
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getOperands();
    }

    final Filter<? super R> optimize(Optimization optimization, Filter<R> filter, Filter<R> filter2) {
        boolean bl = true;
        Class<?> clazz = this.getClass();
        LinkedHashSet<Filter<? super R>> linkedHashSet = new LinkedHashSet<Filter<? super R>>();
        for (Filter<? super R> filter3 : this.operands) {
            Filter<R> filter32 = optimization.apply(filter3);
            bl &= filter3 == filter32;
            if (filter32 == filter) {
                bl = false;
                continue;
            }
            if (filter32 == filter2) {
                return filter2;
            }
            if (filter32.getClass() != clazz) {
                bl &= linkedHashSet.add(filter32);
                continue;
            }
            bl = false;
            for (Filter<R> filter4 : ((LogicalFilter)filter32).operands) {
                if (filter32 == filter) continue;
                if (filter32 == filter2) {
                    return filter2;
                }
                assert (filter4.getClass() != clazz);
                linkedHashSet.add(optimization.apply(filter4));
            }
        }
        for (Filter filter5 : linkedHashSet) {
            if (!LogicalOperatorName.NOT.equals(filter5.getOperatorType()) || !linkedHashSet.containsAll(((LogicalOperator)filter5).getOperands())) continue;
            return filter2;
        }
        if (bl) {
            return this;
        }
        Filter filter6 = (Filter)CollectionsExt.singletonOrNull(linkedHashSet);
        return filter6 != null ? filter6 : this.createSameType(linkedHashSet);
    }

    static final class Not<R>
    extends FilterNode<R>
    implements LogicalOperator<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -1296823195138427781L;
        private final Filter<? super R> operand;

        Not(Filter<? super R> filter) {
            ArgumentChecks.ensureNonNull((String)"operand", filter);
            this.operand = filter;
        }

        @Override
        public LogicalOperatorName getOperatorType() {
            return LogicalOperatorName.NOT;
        }

        @Override
        protected char symbol() {
            return '\u00ac';
        }

        @Override
        protected final Collection<?> getChildren() {
            return this.getOperands();
        }

        @Override
        public List<Filter<? super R>> getOperands() {
            return Collections.singletonList(this.operand);
        }

        @Override
        public boolean test(R r) {
            return !this.operand.test(r);
        }

        @Override
        public Filter<? super R> optimize(Optimization optimization) {
            Filter<? super R> filter = optimization.apply(this.operand);
            if (filter == Filter.include()) {
                return Filter.exclude();
            }
            if (filter == Filter.exclude()) {
                return Filter.include();
            }
            if (filter instanceof Not) {
                return ((Not)filter).operand;
            }
            return filter != this.operand ? new Not<R>(filter) : this;
        }
    }

    static final class Or<R>
    extends LogicalFilter<R> {
        private static final long serialVersionUID = 3805785720811330282L;

        Or(Collection<? extends Filter<? super R>> collection) {
            super(collection);
        }

        Or(Filter<? super R> filter, Filter<? super R> filter2) {
            super(filter, filter2);
        }

        @Override
        protected LogicalFilter<R> createSameType(Collection<? extends Filter<? super R>> collection) {
            return new Or<R>(collection);
        }

        @Override
        public LogicalOperatorName getOperatorType() {
            return LogicalOperatorName.OR;
        }

        @Override
        protected char symbol() {
            return this.operands.length <= 2 ? (char)'\u2228' : '\u22c1';
        }

        @Override
        public boolean test(R r) {
            for (Filter filter : this.operands) {
                if (!filter.test(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Filter<? super R> optimize(Optimization optimization) {
            return this.optimize(optimization, Filter.exclude(), Filter.include());
        }
    }

    static final class And<R>
    extends LogicalFilter<R> {
        private static final long serialVersionUID = 152892064260384713L;

        And(Collection<? extends Filter<? super R>> collection) {
            super(collection);
        }

        And(Filter<? super R> filter, Filter<? super R> filter2) {
            super(filter, filter2);
        }

        @Override
        protected LogicalFilter<R> createSameType(Collection<? extends Filter<? super R>> collection) {
            return new And<R>(collection);
        }

        @Override
        public LogicalOperatorName getOperatorType() {
            return LogicalOperatorName.AND;
        }

        @Override
        protected char symbol() {
            return this.operands.length <= 2 ? (char)'\u2227' : '\u22c0';
        }

        @Override
        public boolean test(R r) {
            for (Filter filter : this.operands) {
                if (filter.test(r)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Filter<? super R> optimize(Optimization optimization) {
            return this.optimize(optimization, Filter.include(), Filter.exclude());
        }
    }
}

