/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.index.persistent.entity;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.services.jcr.ext.index.persistent.JCRIndexingOperationType;

@Entity(name="JCRIndexingQueue")
@ExoEntity
@Table(name="JCR_INDEXING_QUEUE")
@NamedQueries(value={@NamedQuery(name="JCRIndexingQueue.findAllOperationNotExecutedByClusterNode", query="SELECT idx FROM JCRIndexingQueue idx WHERE :clusterNodeName NOT MEMBER OF idx.nodes ORDER BY idx.modificationDate ASC"), @NamedQuery(name="JCRIndexingQueue.findAllOperationNotExecutedByClusterNodePreceedingAnID", query="SELECT idx FROM JCRIndexingQueue idx WHERE idx.id < :lastExecutedId  AND :oldClusterNodeName MEMBER OF idx.nodes AND :clusterNodeName NOT MEMBER OF idx.nodes ORDER BY idx.id ASC"), @NamedQuery(name="JCRIndexingQueue.deleteAllIndexingOperationsSince", query="Delete FROM JCRIndexingQueue idx WHERE idx.id < :id"), @NamedQuery(name="JCRIndexingQueue.deleteOperationsByJCRUUID", query="Delete FROM JCRIndexingQueue idx WHERE idx.jcrUUID = :jcrUUID")})
public class JCRIndexQueueEntity {
    @Id
    @Column(name="INDEXING_QUEUE_ID")
    @SequenceGenerator(name="SEQ_JCR_INDEXING_QUEUE", sequenceName="SEQ_JCR_INDEXING_QUEUE", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_JCR_INDEXING_QUEUE")
    private long id;
    @Column(name="JCR_UUID", nullable=false)
    private String jcrUUID;
    @Column(name="WORKSPACE", nullable=false)
    private String workspace;
    @Column(name="OPERATION_TYPE", nullable=false)
    private JCRIndexingOperationType operationType;
    @Column(name="MODIFICATION_DATE", nullable=false)
    private Calendar modificationDate;
    @Column(name="IS_PARENT_CHANGE", nullable=false)
    private boolean parentChange;
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="JCR_INDEXING_QUEUE_NODES", joinColumns={@JoinColumn(name="INDEXING_QUEUE_ID")})
    @Column(name="NODE_NAME", nullable=false)
    private Set<String> nodes;

    public JCRIndexQueueEntity() {
    }

    public JCRIndexQueueEntity(String jcrUUID, String workspaceName, JCRIndexingOperationType operationType, Calendar modificationDate, boolean parentChange, String nodeName) {
        this.jcrUUID = jcrUUID;
        this.workspace = workspaceName;
        this.operationType = operationType;
        this.modificationDate = modificationDate;
        this.parentChange = parentChange;
        this.addNode(nodeName);
    }

    public long getId() {
        return this.id;
    }

    public String getJcrUUID() {
        return this.jcrUUID;
    }

    public void setJcrUUID(String jcrUUID) {
        this.jcrUUID = jcrUUID;
    }

    public JCRIndexingOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(JCRIndexingOperationType operationType) {
        this.operationType = operationType;
    }

    public Calendar getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Calendar modificationDate) {
        this.modificationDate = modificationDate;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public boolean isParentChange() {
        return this.parentChange;
    }

    public void setParentChange(boolean parentChange) {
        this.parentChange = parentChange;
    }

    public Set<String> getNodes() {
        return this.nodes;
    }

    public void addNode(String nodeName) {
        if (this.nodes == null) {
            this.nodes = new HashSet<String>();
        }
        this.nodes.add(nodeName);
    }
}

