/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.ispn.AbstractIndexerCacheStore;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.remoting.transport.Address;

public class IndexerCacheStore
extends AbstractIndexerCacheStore {
    protected volatile IndexerIoModeHandler modeHandler;
    protected CacheListener listener;
    private Address localAddress;
    private volatile boolean coordinator;
    protected EmbeddedCacheManager cacheManager;

    @Override
    public void init(InitializationContext ctx) {
        super.init(ctx);
        this.cacheManager = ctx.getCache().getCacheManager();
        this.listener = new CacheListener();
        this.cacheManager.addListener((Object)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexerIoModeHandler getModeHandler() {
        if (this.modeHandler == null) {
            if (this.ctx.getCache().getStatus() != ComponentStatus.RUNNING) {
                throw new IllegalStateException("The cache should be started first");
            }
            IndexerCacheStore indexerCacheStore = this;
            synchronized (indexerCacheStore) {
                if (this.modeHandler == null) {
                    this.modeHandler = new IndexerIoModeHandler(this.cacheManager.isCoordinator() || this.ctx.getCache().getAdvancedCache().getRpcManager() == null ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
                }
            }
        }
        return this.modeHandler;
    }

    private boolean isCoordinator(List<Address> newView, Address currentAddress) {
        if (!currentAddress.equals(this.localAddress)) {
            this.localAddress = currentAddress;
        }
        if (this.localAddress != null) {
            return !newView.isEmpty() && this.localAddress.equals(newView.get(0));
        }
        return this.coordinator;
    }

    protected void activeStatusChanged(final boolean newActiveState) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                IndexerCacheStore.this.coordinator = newActiveState;
                IndexerCacheStore.this.getModeHandler().setMode(IndexerCacheStore.this.coordinator ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
                AbstractIndexerCacheStore.LOG.info((Object)("Set indexer io mode to:" + String.valueOf((Object)(IndexerCacheStore.this.coordinator ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY))));
                if (IndexerCacheStore.this.coordinator) {
                    IndexerCacheStore.this.doPushState();
                }
            }
        }, "JCR Indexer ActiveStatusChanged-handler").start();
    }

    protected void doPushState() {
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug((Object)"start pushing in-memory state to cache cacheLoader collection");
        }
        HashMap<String, ChangesFilterListsWrapper> changesMap = new HashMap<String, ChangesFilterListsWrapper>();
        ArrayList<ChangesKey> processedItemKeys = new ArrayList<ChangesKey>();
        DataContainer dc = this.ctx.getCache().getAdvancedCache().getDataContainer();
        Set keys = dc.keySet();
        for (Object e : keys) {
            InternalCacheEntry entry = dc.get(e);
            if (entry == null || !(entry.getValue() instanceof ChangesFilterListsWrapper) || !(entry.getKey() instanceof ChangesKey)) continue;
            if (debugEnabled) {
                LOG.debug((Object)"Received list wrapper, start indexing...");
            }
            ChangesFilterListsWrapper staleListIncache = (ChangesFilterListsWrapper)entry.getValue();
            ChangesKey key = (ChangesKey)entry.getKey();
            ChangesFilterListsWrapper listToPush = (ChangesFilterListsWrapper)changesMap.get(key.getWsId());
            if (listToPush == null) {
                listToPush = new ChangesFilterListsWrapper(new HashSet<String>(), new HashSet<String>(), new HashSet<String>(), new HashSet<String>());
                changesMap.put(key.getWsId(), listToPush);
            }
            if (staleListIncache.getParentAddedNodes() != null) {
                listToPush.getParentAddedNodes().addAll(staleListIncache.getParentAddedNodes());
            }
            if (staleListIncache.getParentRemovedNodes() != null) {
                listToPush.getParentRemovedNodes().addAll(staleListIncache.getParentRemovedNodes());
            }
            if (staleListIncache.getAddedNodes() != null) {
                listToPush.getAddedNodes().addAll(staleListIncache.getAddedNodes());
            }
            if (staleListIncache.getRemovedNodes() != null) {
                listToPush.getRemovedNodes().addAll(staleListIncache.getRemovedNodes());
            }
            processedItemKeys.add(key);
        }
        for (Map.Entry entry : changesMap.entrySet()) {
            ChangesKey changesKey = new ChangesKey((String)entry.getKey(), IdGenerator.generate());
            this.ctx.getCache().putAsync((Object)changesKey, entry.getValue());
        }
        for (ChangesKey changesKey : processedItemKeys) {
            this.ctx.getCache().removeAsync((Object)changesKey);
        }
        if (debugEnabled) {
            LOG.debug((Object)"in-memory state passed to cache cacheStore successfully");
        }
    }

    @Override
    public void stop() {
        this.cacheManager.removeListener((Object)this.listener);
        super.stop();
    }

    @Listener
    public class CacheListener {
        @CacheStarted
        public void cacheStarted(Event e) {
            IndexerCacheStore.this.localAddress = IndexerCacheStore.this.cacheManager.getAddress();
            IndexerCacheStore.this.coordinator = IndexerCacheStore.this.cacheManager.isCoordinator();
        }

        @ViewChanged
        @Merged
        public void viewChange(ViewChangedEvent event) {
            AbstractIndexerCacheStore.LOG.info((Object)("The intercepted EventType is : " + String.valueOf(event.getType())));
            AbstractIndexerCacheStore.LOG.info((Object)("The old list of members : " + String.valueOf(event.getOldMembers())));
            AbstractIndexerCacheStore.LOG.info((Object)("The new list of members: : " + String.valueOf(event.getNewMembers())));
            boolean tmp = IndexerCacheStore.this.isCoordinator(event.getNewMembers(), event.getLocalAddress());
            if (IndexerCacheStore.this.coordinator != tmp || tmp && event.isMergeView()) {
                IndexerCacheStore.this.activeStatusChanged(tmp);
            }
        }
    }
}

