/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.ComplexDataRestore;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBBackup;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.backup.rdbms.DirectoryRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.TableTransformationRule;
import org.exoplatform.services.jcr.impl.backup.rdbms.TableTransformationRuleGenerator;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanService;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanerTool;
import org.exoplatform.services.jcr.impl.core.query.NodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.core.query.Reindexable;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.HSQLDBConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MSSQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.SybaseConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.indexing.JdbcNodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.DB2DBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.HSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.MSSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.MysqlDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.SybaseDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.statistics.StatisticsJDBCStorageConnection;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jdbc.DataSourceProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class JDBCWorkspaceDataContainer
extends WorkspaceDataContainerBase
implements Startable,
Backupable,
Reindexable {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCWorkspaceDataContainer");
    public static final boolean STATISTICS_ENABLED = Boolean.valueOf(PrivilegedSystemHelper.getProperty((String)"JDBCWorkspaceDataContainer.statistics.enabled"));
    public static final String SOURCE_NAME = "source-name";
    public static final String DB_STRUCTURE_TYPE = "db-structure-type";
    public static final String USE_SEQUENCE_FOR_ORDER_NUMBER = "use-sequence-for-order-number";
    public static final String DB_TABLENAME_SUFFIX = "db-tablename-suffix";
    public static final String DB_DIALECT = "dialect";
    public static final String USE_SEQUENCE_AUTO = "auto";
    public static final String DB_FORCE_QUERY_HINTS = "force.query.hints";
    public static final String BATCH_SIZE = "batch-size";
    public static ExecutorService executor;
    public static final int DEFAULT_BATCHING_DISABLED = -1;
    protected JDBCDataContainerConfig containerConfig;
    public GenericConnectionFactory connFactory;
    protected final WorkspaceEntry wsConfig;

    public JDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider, DataSourceProvider dsProvider, FileCleanerHolder fileCleanerHolder) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        this.checkIntegrity(wsConfig, repConfig);
        this.wsConfig = wsConfig;
        this.containerConfig = new JDBCDataContainerConfig();
        this.containerConfig.containerName = wsConfig.getName();
        this.containerConfig.uniqueName = wsConfig.getUniqueName();
        this.containerConfig.dbStructureType = DBInitializerHelper.getDatabaseType(wsConfig);
        this.containerConfig.dbTableSuffix = DBInitializerHelper.getDBTableSuffix(wsConfig);
        this.containerConfig.valueStorageProvider = valueStorageProvider;
        this.containerConfig.dsProvider = dsProvider;
        this.containerConfig.batchSize = wsConfig.getContainer().getParameterInteger(BATCH_SIZE, -1);
        String pDbDialect = this.validateDialect(DBInitializerHelper.getDatabaseDialect(wsConfig));
        this.containerConfig.dbSourceName = wsConfig.getContainer().getParameterValue(SOURCE_NAME);
        if (dsProvider == null) {
            throw new IllegalArgumentException("Since a data source has been defined, the DataSourceProvider cannot be null, add it in your configuration.");
        }
        this.containerConfig.isManaged = dsProvider.isManaged(this.containerConfig.dbSourceName);
        if (pDbDialect.startsWith("AUTO")) {
            final DataSource ds = this.getDataSource();
            Connection jdbcConn = null;
            try {
                jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return ds.getConnection();
                    }
                });
                this.containerConfig.dbDialect = DialectDetecter.detect((DatabaseMetaData)jdbcConn.getMetaData());
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                if (jdbcConn != null) {
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
            }
        }
        this.containerConfig.dbDialect = pDbDialect;
        this.containerConfig.useQueryHints = wsConfig.getContainer().getParameterBoolean(DB_FORCE_QUERY_HINTS, true);
        try {
            this.containerConfig.checkSNSNewConnection = wsConfig.getContainer().getParameterBoolean("check-sns-new-connection");
        }
        catch (RepositoryConfigurationException e) {
            this.containerConfig.checkSNSNewConnection = false;
        }
        try {
            this.containerConfig.useSequenceForOrderNumber = wsConfig.getContainer().getParameterValue(USE_SEQUENCE_FOR_ORDER_NUMBER, USE_SEQUENCE_AUTO).equalsIgnoreCase(USE_SEQUENCE_AUTO) ? JDBCWorkspaceDataContainer.useSequenceDefaultValue() : wsConfig.getContainer().getParameterBoolean(USE_SEQUENCE_FOR_ORDER_NUMBER);
        }
        catch (RepositoryConfigurationException e) {
            this.containerConfig.useSequenceForOrderNumber = JDBCWorkspaceDataContainer.useSequenceDefaultValue();
        }
        this.containerConfig.spoolConfig = new SpoolConfig(fileCleanerHolder.getFileCleaner());
        try {
            this.containerConfig.spoolConfig.maxBufferSize = wsConfig.getContainer().getParameterInteger("max-buffer-size");
        }
        catch (RepositoryConfigurationException e) {
            this.containerConfig.spoolConfig.maxBufferSize = 204800;
        }
        try {
            String sdParam = wsConfig.getContainer().getParameterValue("swap-directory");
            this.containerConfig.spoolConfig.tempDirectory = new File(sdParam);
        }
        catch (RepositoryConfigurationException e1) {
            this.containerConfig.spoolConfig.tempDirectory = new File(DEF_SWAPDIR);
        }
        if (!PrivilegedFileHelper.exists((File)this.containerConfig.spoolConfig.tempDirectory)) {
            PrivilegedFileHelper.mkdirs((File)this.containerConfig.spoolConfig.tempDirectory);
        } else {
            this.cleanupSwapDirectory();
        }
        SpoolConfig.addSpoolConfig(wsConfig.getName(), this.containerConfig.spoolConfig);
        this.containerConfig.initScriptPath = DBInitializerHelper.scriptPath(this.containerConfig.dbDialect, this.containerConfig.dbStructureType.isMultiDatabase());
        LOG.info((Object)this.getInfo());
        this.initDatabase();
    }

    private void cleanupSwapDirectory() {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                File[] files = JDBCWorkspaceDataContainer.this.containerConfig.spoolConfig.tempDirectory.listFiles();
                if (files != null && files.length > 0) {
                    LOG.info((Object)"Some files have been found in the swap directory and will be deleted");
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        file.delete();
                    }
                }
                return null;
            }
        };
        SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        return new GenericConnectionFactory(this.getDataSource(), this.containerConfig);
    }

    protected DBInitializer defaultDBInitializer() throws NamingException, RepositoryException, IOException {
        return new DBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
    }

    protected void checkIntegrity(WorkspaceEntry wsConfig, RepositoryEntry repConfig) throws RepositoryConfigurationException {
        JDBCDataContainerConfig.DatabaseStructureType dbType = DBInitializerHelper.getDatabaseType(wsConfig);
        for (WorkspaceEntry wsEntry : repConfig.getWorkspaceEntries()) {
            String newWsSourceName;
            String wsSourceName;
            block5: {
                if (wsEntry.getName().equals(wsConfig.getName()) || !wsEntry.getContainer().getType().equals(wsConfig.getContainer().getType()) || !wsEntry.getContainer().getType().equals(this.getClass().getName())) continue;
                if (!DBInitializerHelper.getDatabaseType(wsEntry).equals((Object)dbType)) {
                    throw new RepositoryConfigurationException("All workspaces must be of same DB type. But " + wsEntry.getName() + "=" + String.valueOf((Object)DBInitializerHelper.getDatabaseType(wsEntry)) + " and " + wsConfig.getName() + "=" + String.valueOf((Object)dbType));
                }
                wsSourceName = null;
                newWsSourceName = null;
                try {
                    wsSourceName = wsEntry.getContainer().getParameterValue("sourceName");
                    newWsSourceName = wsConfig.getContainer().getParameterValue("sourceName");
                }
                catch (RepositoryConfigurationException e) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            if (wsSourceName == null || newWsSourceName == null) continue;
            if (dbType.isShareSameDatasource()) {
                if (wsSourceName.equals(newWsSourceName)) continue;
                throw new RepositoryConfigurationException("SourceName must be equals in " + String.valueOf((Object)dbType) + "-database repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
            }
            if (!wsSourceName.equals(newWsSourceName)) continue;
            throw new RepositoryConfigurationException("SourceName " + wsSourceName + " already in use in " + wsEntry.getName() + ". SourceName must be different in " + String.valueOf((Object)dbType) + "-database structure type. Check configuration for " + wsConfig.getName());
        }
    }

    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        DBInitializer dbInitializer = null;
        if (this.containerConfig.dbDialect.equals("ORACLE-OCI")) {
            LOG.warn((Object)"ORACLE-OCI dialect is experimental!");
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new OracleDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("ORACLE")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new OracleDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("PGSQL")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new PgSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("MYSQL")) {
            if (this.containerConfig.dbDialect.startsWith("MYSQL-MyISAM")) {
                LOG.warn((Object)"MyISAM is not supported due to its lack of transaction support and integrity check, so use it only if you don't expect any support and performances in read accesses are more important than the consistency in your use-case. This dialect is only dedicated to the community.");
            }
            this.connFactory = new MySQLConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new MysqlDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("MSSQL")) {
            this.connFactory = new MSSQLConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new MSSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("DERBY")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = this.defaultDBInitializer();
        } else if (this.containerConfig.dbDialect.startsWith("DB2")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new DB2DBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("SYBASE")) {
            this.connFactory = new SybaseConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new SybaseDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("INGRES")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new IngresSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("HSQLDB")) {
            this.connFactory = new HSQLDBConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new HSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = this.defaultDBInitializer();
        }
        try {
            dbInitializer.init();
        }
        catch (DBInitializerException e) {
            LOG.error((Object)("Error of init db " + String.valueOf(e)), (Throwable)e);
        }
    }

    protected GenericConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    @Override
    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        WorkspaceStorageConnection con = this.connFactory.openConnection();
        if (STATISTICS_ENABLED) {
            con = new StatisticsJDBCStorageConnection(con);
        }
        return con;
    }

    @Override
    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        WorkspaceStorageConnection con = this.connFactory.openConnection(readOnly);
        if (STATISTICS_ENABLED) {
            con = new StatisticsJDBCStorageConnection(con);
        }
        return con;
    }

    @Override
    public WorkspaceStorageConnection reuseConnection(WorkspaceStorageConnection original) throws RepositoryException {
        if (original instanceof StatisticsJDBCStorageConnection) {
            original = ((StatisticsJDBCStorageConnection)original).getNestedWorkspaceStorageConnection();
        }
        if (original instanceof JDBCStorageConnection) {
            final JDBCStorageConnection storageConnection = (JDBCStorageConnection)original;
            final Connection connection = storageConnection.getJdbcConnection();
            storageConnection.share();
            final Connection proxyConnection = (Connection)Proxy.newProxyInstance(GenericConnectionFactory.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("close".equals(method.getName()) && storageConnection.release() > 0) {
                        return null;
                    }
                    if (("commit".equals(method.getName()) || "rollback".equals(method.getName())) && storageConnection.getDbConnectionTotalUsed() > 1) {
                        return null;
                    }
                    return method.invoke((Object)connection, args);
                }
            });
            GenericConnectionFactory cFactory = this.connFactory.cloneWith((DataSource)Proxy.newProxyInstance(GenericConnectionFactory.class.getClassLoader(), new Class[]{DataSource.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("getConnection".equals(method.getName())) {
                        return proxyConnection;
                    }
                    return method.invoke((Object)JDBCWorkspaceDataContainer.this.getDataSource(), args);
                }
            }));
            return STATISTICS_ENABLED ? new StatisticsJDBCStorageConnection(cFactory.openConnection(false)) : cFactory.openConnection(false);
        }
        return this.openConnection(false);
    }

    @Override
    public String getName() {
        return this.containerConfig.containerName;
    }

    @Override
    public String getUniqueName() {
        return this.containerConfig.uniqueName;
    }

    @Override
    public String getInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("dialect:");
        builder.append(this.containerConfig.dbDialect);
        builder.append(", ");
        for (SimpleParameterEntry element : this.wsConfig.getContainer().getParameters()) {
            if (element.getName().equals(DB_DIALECT)) continue;
            builder.append(element.getName());
            builder.append(":");
            builder.append(element.getValue());
            builder.append(", ");
        }
        builder.append("value storage provider: ");
        builder.append(this.containerConfig.valueStorageProvider);
        return builder.toString();
    }

    @Override
    public String getStorageVersion() {
        return this.containerConfig.storageVersion;
    }

    public void start() {
        Connection con = null;
        try {
            con = this.getConnectionFactory().getJdbcConnection();
            if (con.getTransactionIsolation() < 2) {
                LOG.warn((Object)"Wrong default isolation level, please set the default isolation level to READ_COMMITTED or higher. Other default isolation levels are not supported");
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Error checking isolation level configuration.", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error checking isolation level configuration.", (Throwable)e);
        }
        finally {
            block23: {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        if (!LOG.isTraceEnabled()) break block23;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        boolean deleteLocks = "true".equalsIgnoreCase(PrivilegedSystemHelper.getProperty((String)"org.exoplatform.jcr.locks.force.remove", (String)"false"));
        if (deleteLocks) {
            try {
                WorkspaceStorageConnection wsc = this.openConnection(false);
                if (wsc instanceof StatisticsJDBCStorageConnection) {
                    wsc = ((StatisticsJDBCStorageConnection)wsc).getNestedWorkspaceStorageConnection();
                }
                final JDBCStorageConnection conn = (JDBCStorageConnection)wsc;
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        boolean failed = true;
                        try {
                            conn.deleteLockProperties();
                            conn.commit();
                            failed = false;
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Can't remove lock properties because of " + e.getMessage()), (Throwable)e);
                        }
                        finally {
                            if (failed) {
                                try {
                                    conn.rollback();
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Can't remove lock properties because of " + e.getMessage()), (Throwable)e);
                                }
                            }
                        }
                    }
                };
                if (executor.isShutdown()) {
                    executor = Executors.newSingleThreadExecutor();
                }
                executor.execute(task);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Can't remove lock properties because of " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void stop() {
        executor.shutdownNow();
    }

    @Override
    public boolean isSame(WorkspaceDataContainer another) {
        if (another == this) {
            return true;
        }
        if (another instanceof JDBCWorkspaceDataContainer) {
            JDBCWorkspaceDataContainer anotherJdbc = (JDBCWorkspaceDataContainer)another;
            return this.getDbSourceName().equals(anotherJdbc.getDbSourceName());
        }
        return false;
    }

    protected String getDbSourceName() {
        return this.containerConfig.dbSourceName;
    }

    @Override
    public boolean isCheckSNSNewConnection() {
        return this.containerConfig.checkSNSNewConnection;
    }

    @Override
    public void clean() throws BackupException {
        LOG.info((Object)("Start to clean value storage of the workspace '" + this.containerConfig.containerName + "'"));
        try {
            DBCleanService.cleanWorkspaceData(this.wsConfig);
            if (this.wsConfig.getContainer().getValueStorages() != null) {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, RepositoryConfigurationException {
                        for (ValueStorageEntry valueStorage : JDBCWorkspaceDataContainer.this.wsConfig.getContainer().getValueStorages()) {
                            File valueStorageDir = new File(valueStorage.getParameterValue("path"));
                            if (!valueStorageDir.exists()) continue;
                            DirectoryHelper.removeDirectory(valueStorageDir);
                        }
                        return null;
                    }
                });
            }
        }
        catch (DBCleanException e) {
            throw new BackupException(e);
        }
        catch (PrivilegedActionException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void backup(final File storageDir) throws BackupException {
        LOG.info((Object)("Start to backup value storage of the workspace '" + this.containerConfig.containerName + "'"));
        ObjectWriter backupInfo = null;
        try {
            backupInfo = new ObjectWriterImpl(PrivilegedFileHelper.fileOutputStream((File)new File(storageDir, "JDBCWorkspaceDataContainer.info")));
            backupInfo.writeString(this.containerConfig.containerName);
            backupInfo.writeString(this.containerConfig.dbStructureType.toString());
            HashMap<String, String> scripts = new HashMap<String, String>();
            String itemTable = DBInitializerHelper.getItemTableName(this.containerConfig);
            String valueTable = DBInitializerHelper.getValueTableName(this.containerConfig);
            String refTable = DBInitializerHelper.getRefTableName(this.containerConfig);
            backupInfo.writeString(itemTable);
            backupInfo.writeString(valueTable);
            backupInfo.writeString(refTable);
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                scripts.put(itemTable, "select * from " + itemTable + " where NAME <> '__root_parent'");
                scripts.put(valueTable, "select * from " + valueTable);
                scripts.put(refTable, "select * from " + refTable);
            } else {
                scripts.put(itemTable, "select * from " + itemTable + " where CONTAINER_NAME='" + this.containerConfig.containerName + "'");
                scripts.put(valueTable, "select V.* from " + valueTable + " V, " + itemTable + " I where I.ID=V.PROPERTY_ID and I.CONTAINER_NAME='" + this.containerConfig.containerName + "'");
                scripts.put(refTable, "select R.* from " + refTable + " R, " + itemTable + " I where I.ID=R.PROPERTY_ID and I.CONTAINER_NAME='" + this.containerConfig.containerName + "'");
            }
            Connection jdbcConn = this.connFactory.getJdbcConnection();
            DBBackup.backup(storageDir, jdbcConn, scripts);
            if (this.wsConfig.getContainer().getValueStorages() != null) {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws RepositoryConfigurationException, IOException {
                        for (ValueStorageEntry valueStorage : JDBCWorkspaceDataContainer.this.wsConfig.getContainer().getValueStorages()) {
                            Boolean enable = valueStorage.getParameterBoolean("enabled", true);
                            if (!enable.booleanValue()) continue;
                            File srcDir = new File(valueStorage.getParameterValue("path"));
                            if (!srcDir.exists()) {
                                throw new IOException("Can't backup value storage. Directory " + srcDir.getName() + " doesn't exist");
                            }
                            File zipFile = new File(storageDir, "values-" + valueStorage.getId() + ".zip");
                            DirectoryHelper.compressDirectory(srcDir, zipFile);
                        }
                        return null;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (RepositoryException e) {
            throw new BackupException(e);
        }
        catch (PrivilegedActionException e) {
            throw new BackupException(e);
        }
        finally {
            if (backupInfo != null) {
                try {
                    backupInfo.close();
                }
                catch (IOException e) {
                    throw new BackupException(e);
                }
            }
        }
    }

    @Override
    public DataRestore getDataRestorer(DataRestoreContext dataRestoreContext) throws BackupException {
        try {
            ArrayList<DataRestore> restorers = new ArrayList<DataRestore>();
            LinkedHashMap<String, TableTransformationRule> tables = new LinkedHashMap<String, TableTransformationRule>();
            Connection jdbcConn = this.getJdbcConnection(dataRestoreContext);
            DBCleanerTool dbCleaner = this.getDbCleaner(dataRestoreContext, jdbcConn);
            File storageDir = this.getStorageDir(dataRestoreContext);
            TableTransformationRuleGenerator tableTransformationRuleGenerator = new TableTransformationRuleGenerator(this.containerConfig, storageDir);
            tables.put(DBInitializerHelper.getItemTableName(this.containerConfig), tableTransformationRuleGenerator.getItemTableTransformationRule());
            tables.put(DBInitializerHelper.getValueTableName(this.containerConfig), tableTransformationRuleGenerator.getValueTableTransformationRule());
            tables.put(DBInitializerHelper.getRefTableName(this.containerConfig), tableTransformationRuleGenerator.getRefTableTransformationRule());
            restorers.add(new DBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.containerConfig.spoolConfig.fileCleaner, dbCleaner));
            if (this.wsConfig.getContainer().getValueStorages() != null) {
                List<File> dataDirsList = this.initDataDirs();
                List<File> backupDirsList = this.initBackupDirs(storageDir);
                if (!dataDirsList.isEmpty() || !backupDirsList.isEmpty()) {
                    restorers.add(new DirectoryRestore(dataDirsList, backupDirsList));
                }
            }
            return new ComplexDataRestore(restorers);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (NamingException e) {
            throw new BackupException(e);
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
    }

    private List<File> initBackupDirs(File storageDir) throws RepositoryConfigurationException {
        ArrayList<File> backupDirsList = new ArrayList<File>();
        for (ValueStorageEntry valueStorage : this.wsConfig.getContainer().getValueStorages()) {
            Boolean enable = valueStorage.getParameterBoolean("enabled", true);
            if (!enable.booleanValue()) continue;
            File zipFile = new File(storageDir, "values-" + valueStorage.getId() + ".zip");
            if (PrivilegedFileHelper.exists((File)zipFile)) {
                backupDirsList.add(zipFile);
                continue;
            }
            zipFile = new File(storageDir, "values/" + valueStorage.getId());
            if (PrivilegedFileHelper.exists((File)zipFile)) {
                backupDirsList.add(zipFile);
                continue;
            }
            throw new RepositoryConfigurationException("There is no backup data for value storage with id " + valueStorage.getId());
        }
        return backupDirsList;
    }

    private List<File> initDataDirs() throws RepositoryConfigurationException {
        ArrayList<File> dataDirsList = new ArrayList<File>();
        for (ValueStorageEntry valueStorage : this.wsConfig.getContainer().getValueStorages()) {
            Boolean enable = valueStorage.getParameterBoolean("enabled", true);
            if (!enable.booleanValue()) continue;
            File dataDir = new File(valueStorage.getParameterValue("path"));
            dataDirsList.add(dataDir);
        }
        return dataDirsList;
    }

    private DBCleanerTool getDbCleaner(DataRestoreContext context, Connection jdbcConn) throws BackupException {
        DBCleanerTool dbCleaner;
        if (context.getObject("db-cleaner") != null) {
            dbCleaner = (DBCleanerTool)context.getObject("db-cleaner");
        } else {
            try {
                dbCleaner = DBCleanService.getWorkspaceDBCleaner(jdbcConn, this.wsConfig);
            }
            catch (DBCleanException e) {
                throw new BackupException(e);
            }
        }
        return dbCleaner;
    }

    private File getStorageDir(DataRestoreContext context) {
        return (File)context.getObject("storage-dir");
    }

    private Connection getJdbcConnection(DataRestoreContext context) throws BackupException {
        Connection jdbcConnection = null;
        if (context.getObject("db-connection") == null) {
            try {
                jdbcConnection = this.connFactory.getJdbcConnection();
                jdbcConnection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new BackupException(e);
            }
            catch (RepositoryException e) {
                throw new BackupException(e);
            }
        } else {
            jdbcConnection = (Connection)context.getObject("db-connection");
        }
        return jdbcConnection;
    }

    @Override
    public NodeDataIndexingIterator getNodeDataIndexingIterator(int pageSize) throws RepositoryException {
        if (this.isReindexingSupported()) {
            return new JdbcNodeDataIndexingIterator(this.connFactory, pageSize);
        }
        throw new UnsupportedOperationException("The method getNodeDataIndexingIterator is not supported for this type of connection use the complex queries instead");
    }

    @Override
    public boolean isReindexingSupported() {
        return this.connFactory.isReindexingSupported();
    }

    @Override
    public Long getNodesCount() throws RepositoryException {
        try (WorkspaceStorageConnection conn = this.connFactory.openConnection();){
            Long l = conn.getNodesCount();
            return l;
        }
    }

    protected DataSource getDataSource() throws RepositoryException {
        try {
            return this.containerConfig.dsProvider.getDataSource(this.containerConfig.dbSourceName);
        }
        catch (NamingException e) {
            throw new RepositoryException("Datasource '" + this.containerConfig.dbSourceName + "' is not bound in this context.", (Throwable)e);
        }
    }

    public static boolean useSequenceDefaultValue() {
        return false;
    }

    private String validateDialect(String confParam) {
        for (String dbType : DBConstants.DB_DIALECTS) {
            if (!confParam.equals(dbType)) continue;
            return dbType;
        }
        return "AUTO";
    }

    static {
        if (STATISTICS_ENABLED) {
            LOG.info((Object)"The statistics of the component JDBCWorkspaceDataContainer has been enabled");
        }
        executor = Executors.newSingleThreadExecutor();
    }
}

