/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompoundIterator
implements Iterator {
    protected final Iterator[] iters;
    protected int index;

    public CompoundIterator(Iterator[] iters) {
        if (iters == null || iters.length == 0) {
            throw new IllegalArgumentException("array is null or empty");
        }
        this.iters = iters;
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.iters.length) {
            if (this.iters[this.index] != null && this.iters[this.index].hasNext()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iters[this.index].next();
    }

    @Override
    public void remove() {
        this.iters[this.index].remove();
    }
}

