/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.PolarToCartesian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class CartesianToPolar
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 7698079127743791414L;
    static final CartesianToPolar INSTANCE = new CartesianToPolar();

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private CartesianToPolar() {
        super("Cartesian to polar", "Cartesian to cylindrical", 2);
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertAfter(1, (Number)DoubleDouble.createRadiansToDegrees(), null);
    }

    @Override
    public MathTransform inverse() {
        return PolarToCartesian.INSTANCE;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.hypot(d, d2);
        if (dArray2 != null) {
            dArray2[n2] = d3;
            dArray2[n2 + 1] = Math.atan2(d2, d);
        }
        if (!bl) {
            return null;
        }
        double d4 = d3 * d3;
        return new Matrix2(d / d3, d2 / d3, -d2 / d4, d / d4);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, 2, n2, 2, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += 2 * (n3 - 1);
                    n2 += 2 * (n3 - 1);
                    n4 = -4;
                    n5 = -4;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * 2);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            dArray2[n2++] = Math.hypot(d, d2);
            dArray2[n2++] = Math.atan2(d2, d);
            n += n4;
            n2 += n5;
        }
    }
}

