/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemDefinitionDataHolder {
    private static Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemDefinitionDataHolder");
    private final Map<InternalQName, Map<InternalQName, Map<InternalQName, NodeDefinitionData>>> nodeDefinitions;
    private final Map<InternalQName, Map<InternalQName, Map<Boolean, PropertyDefinitionData>>> propertyDefinitions;
    private final Map<InternalQName, Map<InternalQName, NodeDefinitionData>> defNodeDefinitions;

    public ItemDefinitionDataHolder() {
        this.nodeDefinitions = new HashMap<InternalQName, Map<InternalQName, Map<InternalQName, NodeDefinitionData>>>();
        this.propertyDefinitions = new HashMap<InternalQName, Map<InternalQName, Map<Boolean, PropertyDefinitionData>>>();
        this.defNodeDefinitions = new HashMap<InternalQName, Map<InternalQName, NodeDefinitionData>>();
    }

    private ItemDefinitionDataHolder(Map<InternalQName, Map<InternalQName, Map<InternalQName, NodeDefinitionData>>> nodeDefinitions, Map<InternalQName, Map<InternalQName, Map<Boolean, PropertyDefinitionData>>> propertyDefinitions, Map<InternalQName, Map<InternalQName, NodeDefinitionData>> defNodeDefinitions) {
        this.nodeDefinitions = nodeDefinitions;
        this.propertyDefinitions = propertyDefinitions;
        this.defNodeDefinitions = defNodeDefinitions;
    }

    public NodeDefinitionData getChildNodeDefinition(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionData def = this.getNodeDefinitionFromThisOrSupertypes(parentNodeType, childName, childNodeType);
        return def;
    }

    public NodeDefinitionData getDefaultChildNodeDefinition(InternalQName childName, InternalQName ... nodeTypes) {
        NodeDefinitionData def;
        for (InternalQName parentNodeType : nodeTypes) {
            def = this.getNodeDefinitionDataInternal(parentNodeType, childName);
            if (def == null) continue;
            return def;
        }
        for (InternalQName parentNodeType : nodeTypes) {
            def = this.getNodeDefinitionDataInternal(parentNodeType, Constants.JCR_ANY_NAME);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    public PropertyDefinitionData getPropertyDefinition(InternalQName childName, boolean multiValued, InternalQName parentNodeType) {
        PropertyDefinitionData def = this.getPropertyDefinitionInternal(parentNodeType, childName, multiValued);
        if (def == null) {
            return this.getPropertyDefinitionInternal(parentNodeType, Constants.JCR_ANY_NAME, multiValued);
        }
        return def;
    }

    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName ... nodeTypes) {
        PropertyDefinitionDatas pdefs = new PropertyDefinitionDatas();
        for (InternalQName nt : nodeTypes) {
            PropertyDefinitionData def = this.getPropertyDefinitionInternal(nt, propertyName, false);
            if (def != null && pdefs.getDefinition(def.isMultiple()) == null) {
                pdefs.setDefinition(def);
            }
            if ((def = this.getPropertyDefinitionInternal(nt, propertyName, true)) == null || pdefs.getDefinition(def.isMultiple()) != null) continue;
            pdefs.setDefinition(def);
        }
        return pdefs.getAnyDefinition() != null ? pdefs : null;
    }

    void putDefinitions(InternalQName name, NodeTypeData nodeType) {
        PropertyDefinitionData[] propDefs;
        NodeDefinitionData[] nodeDefs;
        for (NodeDefinitionData nodeDef : nodeDefs = nodeType.getDeclaredChildNodeDefinitions()) {
            for (InternalQName rnt : nodeDef.getRequiredPrimaryTypes()) {
                this.addNodeDefinitionDataInternal(name, nodeDef.getName(), rnt, nodeDef);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("NodeDef added: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName().getAsString() + " childNT: " + rnt.getAsString()));
            }
            this.addNodeDefinitionDataInternal(name, nodeDef.getName(), nodeDef);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Default NodeDef added: parent NT: " + name.getAsString() + " child nodeName: " + String.valueOf((Object)nodeDef.getName())));
        }
        for (PropertyDefinitionData propDef : propDefs = nodeType.getDeclaredPropertyDefinitions()) {
            this.addPropertyDefinitionInternal(name, propDef.getName(), propDef.isMultiple(), propDef);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("PropDef added: parent NT: " + name.getAsString() + " child propName: " + propDef.getName().getAsString() + " isMultiple: " + propDef.isMultiple()));
        }
    }

    void removeDefinitions(InternalQName name, NodeTypeData nodeType) {
        PropertyDefinitionData[] propDefs;
        NodeDefinitionData[] nodeDefs;
        for (NodeDefinitionData nodeDef : nodeDefs = nodeType.getDeclaredChildNodeDefinitions()) {
            for (InternalQName rnt : nodeDef.getRequiredPrimaryTypes()) {
                this.removeNodeDefinitionDataInternal(name, nodeDef.getName(), rnt);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("NodeDef removed: parent NT: " + name.getAsString() + " child nodeName: " + nodeDef.getName().getAsString() + " childNT: " + rnt.getAsString()));
            }
            this.removeNodeDefinitionDataInternal(name, nodeDef.getName());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Default NodeDef removed: parent NT: " + name.getAsString() + " child nodeName: " + String.valueOf((Object)nodeDef.getName())));
        }
        for (PropertyDefinitionData propDef : propDefs = nodeType.getDeclaredPropertyDefinitions()) {
            this.removePropertyDefinitionInternal(name, propDef.getName(), propDef.isMultiple());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("PropDef remode: parent NT: " + name.getAsString() + " child propName: " + propDef.getName().getAsString() + " isMultiple: " + propDef.isMultiple()));
        }
    }

    private NodeDefinitionData getNodeDefinitionFromThisOrSupertypes(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionData def = this.getNodeDefinitionDataInternal(parentNodeType, childName, childNodeType);
        if (def != null) {
            return def;
        }
        return def;
    }

    private NodeDefinitionData getNodeDefinitionDataInternal(InternalQName parentNodeType, InternalQName childName) {
        Map<InternalQName, NodeDefinitionData> defs = this.defNodeDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            return null;
        }
        return defs.get((Object)childName);
    }

    private void addNodeDefinitionDataInternal(InternalQName parentNodeType, InternalQName childName, NodeDefinitionData nodeDef) {
        Map<InternalQName, NodeDefinitionData> defs = this.defNodeDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            defs = new HashMap<InternalQName, NodeDefinitionData>();
            this.defNodeDefinitions.put(parentNodeType, defs);
        }
        defs.put(childName, nodeDef);
    }

    private void removeNodeDefinitionDataInternal(InternalQName parentNodeType, InternalQName childName) {
        Map<InternalQName, NodeDefinitionData> defs = this.defNodeDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            return;
        }
        defs.remove((Object)childName);
    }

    private PropertyDefinitionData getPropertyDefinitionInternal(InternalQName parentNodeType, InternalQName childName, boolean multiValued) {
        Map<InternalQName, Map<Boolean, PropertyDefinitionData>> defs = this.propertyDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            return null;
        }
        Map<Boolean, PropertyDefinitionData> def = defs.get((Object)childName);
        if (def == null) {
            return null;
        }
        return def.get(multiValued);
    }

    private void addPropertyDefinitionInternal(InternalQName parentNodeType, InternalQName childName, boolean multiValued, PropertyDefinitionData propDef) {
        Map<Boolean, PropertyDefinitionData> def;
        Map<InternalQName, Map<Boolean, PropertyDefinitionData>> defs = this.propertyDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            defs = new HashMap<InternalQName, Map<Boolean, PropertyDefinitionData>>();
            this.propertyDefinitions.put(parentNodeType, defs);
        }
        if ((def = defs.get((Object)childName)) == null) {
            def = new HashMap<Boolean, PropertyDefinitionData>();
            defs.put(childName, def);
        }
        def.put(multiValued, propDef);
    }

    private void removePropertyDefinitionInternal(InternalQName parentNodeType, InternalQName childName, boolean multiValued) {
        Map<InternalQName, Map<Boolean, PropertyDefinitionData>> defs = this.propertyDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            return;
        }
        Map<Boolean, PropertyDefinitionData> def = defs.get((Object)childName);
        if (def == null) {
            return;
        }
        def.remove(multiValued);
    }

    private NodeDefinitionData getNodeDefinitionDataInternal(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        Map<InternalQName, Map<InternalQName, NodeDefinitionData>> defs = this.nodeDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            return null;
        }
        Map<InternalQName, NodeDefinitionData> def = defs.get((Object)childName);
        if (def == null) {
            return null;
        }
        return def.get((Object)childNodeType);
    }

    private void addNodeDefinitionDataInternal(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType, NodeDefinitionData nodeDef) {
        Map<InternalQName, NodeDefinitionData> def;
        Map<InternalQName, Map<InternalQName, NodeDefinitionData>> defs = this.nodeDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            defs = new HashMap<InternalQName, Map<InternalQName, NodeDefinitionData>>();
            this.nodeDefinitions.put(parentNodeType, defs);
        }
        if ((def = defs.get((Object)childName)) == null) {
            def = new HashMap<InternalQName, NodeDefinitionData>();
            defs.put(childName, def);
        }
        def.put(childNodeType, nodeDef);
    }

    private void removeNodeDefinitionDataInternal(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        Map<InternalQName, Map<InternalQName, NodeDefinitionData>> defs = this.nodeDefinitions.get((Object)parentNodeType);
        if (defs == null) {
            return;
        }
        Map<InternalQName, NodeDefinitionData> def = defs.get((Object)childName);
        if (def == null) {
            return;
        }
        def.remove((Object)childNodeType);
    }

    protected ItemDefinitionDataHolder createCopy() {
        return new ItemDefinitionDataHolder(ItemDefinitionDataHolder.cloneMap(this.nodeDefinitions), ItemDefinitionDataHolder.cloneMap(this.propertyDefinitions), ItemDefinitionDataHolder.cloneMap(this.defNodeDefinitions));
    }

    private static <K, V> Map<K, V> cloneMap(Map<? extends K, ? extends V> map) {
        Map copyMap = (Map)((HashMap)map).clone();
        for (Map.Entry entry : copyMap.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            entry.setValue(ItemDefinitionDataHolder.cloneMap((Map)entry.getValue()));
        }
        return copyMap;
    }
}

