/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.grib.QuasiRegular;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.GaussianLatitudes;
import ucar.unidata.util.StringUtil2;

public class GdsHorizCoordSys {
    private String name;
    public int template;
    public int gdsNumberPoints;
    public int scanMode;
    public ProjectionImpl proj;
    public double startx;
    public double dx;
    public double starty;
    public double dy;
    public int nx;
    public int ny;
    public int nxRaw;
    public int nyRaw;
    public int[] nptsInLine;
    public Array gaussLats;
    public Array gaussw;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GdsHorizCoordSys(String name, int template, int gdsNumberPoints, int scanMode, ProjectionImpl proj, double startx, double dx, double starty, double dy, int nxRaw, int nyRaw, int[] nptsInLine) {
        this.name = name;
        this.template = template;
        this.gdsNumberPoints = gdsNumberPoints;
        this.scanMode = scanMode;
        this.proj = proj;
        this.startx = startx;
        this.dx = dx;
        this.starty = starty;
        this.dy = dy;
        this.nxRaw = nxRaw;
        this.nyRaw = nyRaw;
        if (nptsInLine != null) {
            this.nptsInLine = nptsInLine;
            if (nxRaw > 0) {
                this.nx = nxRaw;
                this.ny = QuasiRegular.getMax(nptsInLine);
                return;
            } else {
                if (nyRaw <= 0) throw new IllegalArgumentException("Quasi Grids nx,ny=" + this.nx + "," + this.ny);
                this.ny = nyRaw;
                this.nx = QuasiRegular.getMax(nptsInLine);
            }
            return;
        } else {
            this.nx = nxRaw;
            this.ny = nyRaw;
        }
    }

    public String getName() {
        return this.name;
    }

    public double getStartX() {
        return this.startx;
    }

    public double getStartY() {
        if (this.gaussLats != null) {
            return this.gaussLats.getDouble(0);
        }
        return this.starty;
    }

    public double getEndX() {
        return this.startx + this.dx * (double)this.nx;
    }

    public double getEndY() {
        if (this.gaussLats != null) {
            return this.gaussLats.getDouble((int)this.gaussLats.getSize() - 1);
        }
        return this.starty + this.dy * (double)this.ny;
    }

    public boolean isLatLon() {
        return this.proj instanceof LatLonProjection;
    }

    public LatLonPoint getCenterLatLon() {
        return this.proj.projToLatLon(this.startx + this.dx * (double)this.nx / 2.0, this.starty + this.dy * (double)this.ny / 2.0);
    }

    public String makeDescription() {
        return this.name + "_" + this.ny + "X" + this.nx + " (Center " + this.getCenterLatLon() + ")";
    }

    public String makeId() {
        StringBuilder result = new StringBuilder(this.name + "_" + this.ny + "X" + this.nx + "-" + this.getCenterLatLon());
        StringUtil2.replace((StringBuilder)result, (String)". ", (String)"p-");
        return result.toString();
    }

    public void setGaussianLats(int nparellels, float la1, float la2) {
        int nlats = 2 * nparellels;
        GaussianLatitudes gaussLats = new GaussianLatitudes(nlats);
        int bestStartIndex = 0;
        int bestEndIndex = 0;
        double bestStartDiff = Double.MAX_VALUE;
        double bestEndDiff = Double.MAX_VALUE;
        for (int i = 0; i < nlats; ++i) {
            double diff = Math.abs(gaussLats.latd[i] - (double)la1);
            if (diff < bestStartDiff) {
                bestStartDiff = diff;
                bestStartIndex = i;
            }
            if (!((diff = Math.abs(gaussLats.latd[i] - (double)la2)) < bestEndDiff)) continue;
            bestEndDiff = diff;
            bestEndIndex = i;
        }
        if (Math.abs(bestEndIndex - bestStartIndex + 1) != this.ny) {
            nlats = this.ny;
            gaussLats = new GaussianLatitudes(nlats);
            bestStartIndex = 0;
            bestEndIndex = this.ny - 1;
        }
        boolean goesUp = bestEndIndex > bestStartIndex;
        int useIndex = bestStartIndex;
        float[] data = new float[this.ny];
        float[] gaussw = new float[this.ny];
        for (int i = 0; i < this.ny; ++i) {
            data[i] = (float)gaussLats.latd[useIndex];
            gaussw[i] = (float)gaussLats.gaussw[useIndex];
            if (goesUp) {
                ++useIndex;
                continue;
            }
            --useIndex;
        }
        this.gaussLats = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{this.ny}, (Object)data);
        this.gaussw = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{this.ny}, (Object)gaussw);
    }

    public String toString() {
        return "GdsHorizCoordSys\n name='" + this.name + '\'' + "\n  template=" + this.template + "\n  gdsNumberPoints=" + this.gdsNumberPoints + "\n  scanMode=" + this.scanMode + "\n  proj=" + this.proj + "\n  startx=" + this.startx + "\n  dx=" + this.dx + "\n  starty=" + this.starty + "\n  dy=" + this.dy + "\n  nx=" + this.nx + "\n  ny=" + this.ny + "\n  gaussLats=" + this.gaussLats + "\n  gaussw=" + this.gaussw + '\n';
    }
}

