/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.apache.pdfbox.preflight.font.container.Type1Container;
import org.apache.pdfbox.preflight.font.descriptor.Type1DescriptorHelper;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class Type1FontValidator
extends SimpleFontValidator<Type1Container> {
    public Type1FontValidator(PreflightContext context, PDSimpleFont font) {
        super(context, (PDFontLike)font, font.getCOSObject(), new Type1Container(font));
    }

    @Override
    protected void createFontDescriptorHelper() {
        this.descriptorHelper = new Type1DescriptorHelper(this.context, (PDSimpleFont)this.font, (Type1Container)this.fontContainer);
    }

    @Override
    protected void checkEncoding() {
        COSBase encoding = this.fontDictionary.getItem(COSName.ENCODING);
        if (encoding != null) {
            COSDocument cosDocument = this.context.getDocument().getDocument();
            if (COSUtils.isString(encoding, cosDocument)) {
                String encodingName = COSUtils.getAsString(encoding, cosDocument);
                if (!(encodingName.equals("MacRomanEncoding") || encodingName.equals("MacExpertEncoding") || encodingName.equals("WinAnsiEncoding") || encodingName.equals("PDFDocEncoding") || encodingName.equals("StandardEncoding"))) {
                    ((Type1Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5"));
                }
            } else if (!COSUtils.isDictionary(encoding, cosDocument)) {
                ((Type1Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5"));
            }
        }
    }
}

