/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.util.FactoryException;

public final class DefinitionVerifier {
    private static final AxesConvention[] VARIANTS = new AxesConvention[]{AxesConvention.NORMALIZED, AxesConvention.DISPLAY_ORIENTED, AxesConvention.RIGHT_HANDED};
    public final CoordinateReferenceSystem recommendation;
    private short resourceKey;
    private Object[] arguments;
    private final Locale locale;
    private static final int METHOD = 0;
    private static final int CONVERSION = 1;
    private static final int CS = 2;
    private static final int DATUM = 3;
    private static final int PRIME_MERIDIAN = 4;
    private static final int OTHER = 5;

    private DefinitionVerifier(CoordinateReferenceSystem coordinateReferenceSystem, Locale locale) {
        this.recommendation = coordinateReferenceSystem;
        this.locale = locale;
    }

    public static void withAuthority(CoordinateReferenceSystem coordinateReferenceSystem, String string, Class<?> clazz, String string2) throws FactoryException {
        LogRecord logRecord;
        DefinitionVerifier definitionVerifier = DefinitionVerifier.withAuthority(coordinateReferenceSystem, null, false, null);
        if (definitionVerifier != null && (logRecord = definitionVerifier.warning(true)) != null) {
            logRecord.setLoggerName(string);
            Logging.log(clazz, (String)string2, (LogRecord)logRecord);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefinitionVerifier withAuthority(CoordinateReferenceSystem coordinateReferenceSystem, CRSAuthorityFactory cRSAuthorityFactory, boolean bl, Locale locale) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        Citation citation = cRSAuthorityFactory != null ? cRSAuthorityFactory.getAuthority() : null;
        String string = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier((IdentifiedObject)coordinateReferenceSystem, citation));
        if (string != null) {
            try {
                if (cRSAuthorityFactory != null) {
                    coordinateReferenceSystem2 = cRSAuthorityFactory.createCoordinateReferenceSystem(string);
                    return DefinitionVerifier.compare(coordinateReferenceSystem, coordinateReferenceSystem2, string != null, string == null, locale);
                }
                coordinateReferenceSystem2 = CRS.forCode(string);
                return DefinitionVerifier.compare(coordinateReferenceSystem, coordinateReferenceSystem2, string != null, string == null, locale);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                DefinitionVerifier definitionVerifier = new DefinitionVerifier(coordinateReferenceSystem, locale);
                definitionVerifier.arguments = new String[]{noSuchAuthorityCodeException.getLocalizedMessage()};
                return definitionVerifier;
            }
        } else {
            if (!bl) return null;
            IdentifiedObjectFinder identifiedObjectFinder = cRSAuthorityFactory instanceof GeodeticAuthorityFactory ? ((GeodeticAuthorityFactory)cRSAuthorityFactory).newIdentifiedObjectFinder() : IdentifiedObjects.newFinder(Citations.getIdentifier((Citation)citation));
            identifiedObjectFinder.setIgnoringAxes(true);
            IdentifiedObject identifiedObject = identifiedObjectFinder.findSingleton((IdentifiedObject)coordinateReferenceSystem);
            if (!(identifiedObject instanceof CoordinateReferenceSystem)) return null;
            coordinateReferenceSystem2 = (CoordinateReferenceSystem)identifiedObject;
        }
        return DefinitionVerifier.compare(coordinateReferenceSystem, coordinateReferenceSystem2, string != null, string == null, locale);
    }

    public static DefinitionVerifier compare(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Locale locale) {
        if (coordinateReferenceSystem == null || coordinateReferenceSystem2 == null) {
            return new DefinitionVerifier(coordinateReferenceSystem != null ? coordinateReferenceSystem : coordinateReferenceSystem2, locale);
        }
        return DefinitionVerifier.compare(coordinateReferenceSystem, coordinateReferenceSystem2, false, false, locale);
    }

    private static DefinitionVerifier compare(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl, boolean bl2, Locale locale) {
        DefinitionVerifier definitionVerifier;
        AbstractCRS abstractCRS;
        int n = 0;
        AbstractCRS abstractCRS2 = abstractCRS = AbstractCRS.castOrCopy(coordinateReferenceSystem2);
        while (!abstractCRS2.equals(coordinateReferenceSystem, ComparisonMode.APPROXIMATE)) {
            if (n < VARIANTS.length) {
                abstractCRS2 = abstractCRS.forConvention(VARIANTS[n++]);
                continue;
            }
            if (bl2) {
                return null;
            }
            n = -1;
            break;
        }
        if (n > 0) {
            definitionVerifier = new DefinitionVerifier(abstractCRS2, locale);
            if (bl) {
                definitionVerifier.resourceKey = (short)72;
                definitionVerifier.arguments = new String[2];
            }
        } else {
            definitionVerifier = new DefinitionVerifier(coordinateReferenceSystem2, locale);
            if (n != 0) {
                definitionVerifier.resourceKey = (short)73;
                definitionVerifier.arguments = new Object[3];
                definitionVerifier.arguments[2] = DefinitionVerifier.diffCode(CRS.getSingleComponents(coordinateReferenceSystem2).iterator(), CRS.getSingleComponents(coordinateReferenceSystem).iterator());
            }
        }
        if (definitionVerifier.arguments != null) {
            definitionVerifier.arguments[0] = IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, locale);
            definitionVerifier.arguments[1] = IdentifiedObjects.getIdentifierOrName((IdentifiedObject)coordinateReferenceSystem2);
        }
        return definitionVerifier;
    }

    private static int diffCode(Iterator<SingleCRS> iterator, Iterator<SingleCRS> iterator2) {
        while (iterator.hasNext() && iterator2.hasNext()) {
            Conversion conversion;
            Conversion conversion2;
            SingleCRS singleCRS;
            SingleCRS singleCRS2 = iterator.next();
            if (Utilities.equalsApproximately((Object)singleCRS2, (Object)(singleCRS = iterator2.next()))) continue;
            if (singleCRS2 instanceof GeneralDerivedCRS && singleCRS instanceof GeneralDerivedCRS && !Utilities.equalsApproximately((Object)(conversion2 = ((GeneralDerivedCRS)singleCRS2).getConversionFromBase()), (Object)(conversion = ((GeneralDerivedCRS)singleCRS).getConversionFromBase()))) {
                return Utilities.equalsApproximately((Object)conversion2.getMethod(), (Object)conversion.getMethod()) ? 1 : 0;
            }
            if (!Utilities.equalsApproximately((Object)singleCRS2.getCoordinateSystem(), (Object)singleCRS.getCoordinateSystem())) {
                return 2;
            }
            conversion2 = singleCRS2.getDatum();
            if (Utilities.equalsApproximately((Object)conversion2, (Object)(conversion = singleCRS.getDatum()))) break;
            if (conversion2 instanceof GeodeticDatum && conversion instanceof GeodeticDatum && !Utilities.equalsApproximately((Object)((GeodeticDatum)conversion2).getPrimeMeridian(), (Object)((GeodeticDatum)conversion).getPrimeMeridian())) {
                return 4;
            }
            return 3;
        }
        return 5;
    }

    public LogRecord warning(boolean bl) {
        if (this.arguments != null) {
            if (this.resourceKey != 0) {
                return Resources.forLocale(this.locale).getLogRecord(Level.WARNING, this.resourceKey, this.arguments);
            }
            if (bl) {
                return new LogRecord(Level.FINE, (String)this.arguments[0]);
            }
        }
        return null;
    }
}

