/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.tika;

import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.Parser;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.document.DocumentReader;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.document.impl.DocumentReaderServiceImpl;
import org.exoplatform.services.document.impl.tika.TikaDocumentReader;
import org.picocontainer.Startable;

public class TikaDocumentReaderServiceImpl
extends DocumentReaderServiceImpl
implements Startable {
    public static final String TIKA_CONFIG_PATH = "tika-configuration";
    public static final String CONTENT_EXTRACTOR_POOL_SIZE = "content-extractor-pool-size";
    private final ExecutorService contentExtractor;
    private final TikaConfig conf;

    public TikaDocumentReaderServiceImpl(ConfigurationManager configManager, InitParams params) throws Exception {
        super(params);
        if (params != null && params.getValueParam(TIKA_CONFIG_PATH) != null) {
            InputStream is = configManager.getInputStream(params.getValueParam(TIKA_CONFIG_PATH).getValue());
            this.conf = new TikaConfig(is);
        } else {
            this.conf = TikaConfig.getDefaultConfig();
        }
        this.contentExtractor = Executors.newCachedThreadPool(new TikaDocumentReaderThreadFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentReader getDocumentReader(String mimeType) throws HandlerNotFoundException {
        DocumentReader reader = (DocumentReader)this.readers_.get(mimeType = mimeType.toLowerCase());
        if (reader != null) {
            return reader;
        }
        Parser tikaParser = this.conf.getParser();
        TikaDocumentReaderServiceImpl tikaDocumentReaderServiceImpl = this;
        synchronized (tikaDocumentReaderServiceImpl) {
            reader = (DocumentReader)this.readers_.get(mimeType);
            if (reader != null) {
                return reader;
            }
            reader = new TikaDocumentReader(tikaParser, mimeType, this.contentExtractor);
            HashMap<String, DocumentReader> tmpReaders = new HashMap<String, DocumentReader>(this.readers_);
            tmpReaders.put(mimeType, reader);
            this.readers_ = tmpReaders;
            return reader;
        }
    }

    public void start() {
    }

    public void stop() {
        this.contentExtractor.shutdown();
    }

    private static class TikaDocumentReaderThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        TikaDocumentReaderThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "content-extractor-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

