/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IndexMigration {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexMigration");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(PersistentIndex index, DirectoryManager directoryManager) throws IOException {
        Directory indexDir = index.getDirectory();
        log.debug("Checking {} ...", new Object[]{indexDir});
        ReadOnlyIndexReader reader = index.getReadOnlyIndexReader();
        try {
            if (IndexFormatVersion.getVersion((IndexReader)reader).getVersion() >= IndexFormatVersion.V3.getVersion()) {
                log.debug((Object)"IndexFormatVersion >= V3, no migration needed");
                return;
            }
            try (TermEnum terms = reader.terms(new Term(FieldNames.PROPERTIES, ""));){
                Term t = terms.term();
                if (t.text().indexOf(65535) == -1) {
                    log.debug((Object)"Index already migrated");
                    return;
                }
            }
        }
        finally {
            reader.release();
            index.releaseWriterAndReaders();
        }
        log.debug("Index requires migration {}", new Object[]{indexDir});
        String migrationName = index.getName() + "_v2.3";
        if (directoryManager.hasDirectory(migrationName)) {
            directoryManager.delete(migrationName);
        }
        try (Directory migrationDir = directoryManager.getDirectory(migrationName);
             IndexWriter writer = new IndexWriter(migrationDir, new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new JcrStandartAnalyzer()));
             MigrationIndexReader r = new MigrationIndexReader(IndexReader.open((Directory)index.getDirectory()));){
            writer.addIndexes(new IndexReader[]{r});
            writer.close();
        }
        directoryManager.delete(index.getName());
        if (!directoryManager.rename(migrationName, index.getName())) {
            throw new IOException("failed to move migrated directory " + String.valueOf(migrationDir));
        }
        log.info((Object)("Migrated " + index.getName()));
    }

    private static class MigrationIndexReader
    extends FilterIndexReader {
        public MigrationIndexReader(IndexReader in) {
            super(in);
        }

        public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
            Document doc = super.document(n, fieldSelector);
            Fieldable[] fields = doc.getFieldables(FieldNames.PROPERTIES);
            if (fields != null) {
                doc.removeFields(FieldNames.PROPERTIES);
                for (int i = 0; i < fields.length; ++i) {
                    String value = fields[i].stringValue();
                    value = value.replace('\uffff', '[');
                    doc.add((Fieldable)new Field(FieldNames.PROPERTIES, value, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
            }
            return doc;
        }

        public TermEnum terms() throws IOException {
            return new MigrationTermEnum(this.in.terms());
        }

        public TermPositions termPositions() throws IOException {
            return new MigrationTermPositions(this.in.termPositions());
        }

        private static class MigrationTermEnum
        extends FilterIndexReader.FilterTermEnum {
            public MigrationTermEnum(TermEnum in) {
                super(in);
            }

            public Term term() {
                Term t = super.term();
                if (t == null) {
                    return t;
                }
                if (t.field().equals(FieldNames.PROPERTIES)) {
                    String text = t.text();
                    return t.createTerm(text.replace('\uffff', '['));
                }
                return t;
            }

            TermEnum unwrap() {
                return this.in;
            }
        }

        private static class MigrationTermPositions
        extends FilterIndexReader.FilterTermPositions {
            public MigrationTermPositions(TermPositions in) {
                super(in);
            }

            public void seek(Term term) throws IOException {
                if (term.field().equals(FieldNames.PROPERTIES)) {
                    char[] text = term.text().toCharArray();
                    text[term.text().indexOf((int)91)] = 65535;
                    super.seek(term.createTerm(new String(text)));
                } else {
                    super.seek(term);
                }
            }

            public void seek(TermEnum termEnum) throws IOException {
                if (termEnum instanceof MigrationTermEnum) {
                    super.seek(((MigrationTermEnum)termEnum).unwrap());
                } else {
                    super.seek(termEnum);
                }
            }
        }
    }
}

