/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.storage.value;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValuePluginFilter;
import org.exoplatform.services.jcr.storage.value.ValueStorageURLConnection;
import org.exoplatform.services.jcr.storage.value.ValueStorageURLStreamHandler;

public abstract class ValueStoragePlugin {
    protected List<ValuePluginFilter> filters;
    protected String id;
    protected String repository;
    protected String workspace;

    public abstract void init(Properties var1, ValueDataResourceHolder var2) throws RepositoryConfigurationException, IOException;

    public abstract ValueIOChannel openIOChannel() throws IOException;

    public final List<ValuePluginFilter> getFilters() {
        return this.filters;
    }

    public final void setFilters(List<ValuePluginFilter> filters) {
        this.filters = filters;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    protected final String getRepository() {
        return this.repository;
    }

    public final void setRepository(String repository) {
        if (this.repository == null) {
            this.repository = repository;
        }
    }

    protected final String getWorkspace() {
        return this.workspace;
    }

    public final void setWorkspace(String workspace) {
        if (this.workspace == null) {
            this.workspace = workspace;
        }
    }

    public ValueStorageURLConnection createURLConnection(URL u) throws IOException {
        return this.getURLStreamHandler().createURLConnection(u, this.repository, this.workspace, this.id);
    }

    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
    }

    public boolean isSame(String storageId) {
        return this.getId().equals(storageId);
    }

    public URL createURL(String resourceId) throws MalformedURLException {
        StringBuilder url = new StringBuilder(64);
        url.append("vs");
        url.append(":/");
        url.append(this.repository);
        url.append('/');
        url.append(this.workspace);
        url.append('/');
        url.append(this.id);
        url.append('/');
        url.append(resourceId);
        return new URL(null, url.toString(), this.getURLStreamHandler());
    }

    protected ValueStorageURLStreamHandler getURLStreamHandler() {
        throw new UnsupportedOperationException("The value storage " + this.repository + "/" + this.workspace + "/" + this.id + " doesn't support URL");
    }
}

