/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.MSOneStorePackage;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.CellManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementPackage;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestObjectGroupReferences;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestRootDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionStoreObjectGroup;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexCellMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageIndexRevisionMapping;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StorageManifestDataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.CellID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.DataElementType;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.HeaderCell;

public class MSOneStoreParser {
    private final Set<CellID> storageIndexHashTab = new HashSet<CellID>();
    private List<DataElement> storageIndexDataElements;
    private List<DataElement> storageManifestDataElements;
    private List<DataElement> cellManifestDataElements;
    private List<DataElement> revisionManifestDataElements;
    private List<DataElement> objectGroupDataElements;
    private List<DataElement> objectBlOBElements;

    public MSOneStorePackage parse(DataElementPackage dataElementPackage) throws IOException {
        MSOneStorePackage msOneStorePackage = new MSOneStorePackage();
        this.storageIndexDataElements = dataElementPackage.dataElements.stream().filter(d -> d.dataElementType == DataElementType.StorageIndexDataElementData).collect(Collectors.toList());
        this.storageManifestDataElements = dataElementPackage.dataElements.stream().filter(d -> d.dataElementType == DataElementType.StorageManifestDataElementData).collect(Collectors.toList());
        this.cellManifestDataElements = dataElementPackage.dataElements.stream().filter(d -> d.dataElementType == DataElementType.CellManifestDataElementData).collect(Collectors.toList());
        this.revisionManifestDataElements = dataElementPackage.dataElements.stream().filter(d -> d.dataElementType == DataElementType.RevisionManifestDataElementData).collect(Collectors.toList());
        this.objectGroupDataElements = dataElementPackage.dataElements.stream().filter(d -> d.dataElementType == DataElementType.ObjectGroupDataElementData).collect(Collectors.toList());
        this.objectBlOBElements = dataElementPackage.dataElements.stream().filter(d -> d.dataElementType == DataElementType.ObjectDataBLOBDataElementData).collect(Collectors.toList());
        msOneStorePackage.storageIndex = (StorageIndexDataElementData)this.storageIndexDataElements.get((int)0).data;
        msOneStorePackage.storageManifest = (StorageManifestDataElementData)this.storageManifestDataElements.get((int)0).data;
        CellID headerCellID = msOneStorePackage.storageManifest.storageManifestRootDeclareList.get((int)0).cellID;
        StorageIndexCellMapping headerCellStorageIndexCellMapping = msOneStorePackage.findStorageIndexCellMapping(headerCellID);
        this.storageIndexHashTab.add(headerCellID);
        if (headerCellStorageIndexCellMapping != null) {
            msOneStorePackage.headerCellCellManifest = this.findCellManifest(headerCellStorageIndexCellMapping.cellMappingExGuid);
            StorageIndexRevisionMapping headerCellRevisionManifestMapping = msOneStorePackage.findStorageIndexRevisionMapping(msOneStorePackage.headerCellCellManifest.cellManifestCurrentRevision.cellManifestCurrentRevisionExGuid);
            msOneStorePackage.headerCellRevisionManifest = this.findRevisionManifestDataElement(headerCellRevisionManifestMapping.revisionMappingExGuid);
            msOneStorePackage.headerCell = this.parseHeaderCell(msOneStorePackage.headerCellRevisionManifest);
            CellID dataRootCellID = msOneStorePackage.storageManifest.storageManifestRootDeclareList.get((int)1).cellID;
            this.storageIndexHashTab.add(dataRootCellID);
            msOneStorePackage.dataRoot = this.parseObjectGroup(dataRootCellID, msOneStorePackage);
            for (StorageIndexCellMapping storageIndexCellMapping : msOneStorePackage.storageIndex.storageIndexCellMappingList) {
                if (this.storageIndexHashTab.contains(storageIndexCellMapping.cellID)) continue;
                msOneStorePackage.OtherFileNodeList.addAll(this.parseObjectGroup(storageIndexCellMapping.cellID, msOneStorePackage));
                this.storageIndexHashTab.add(storageIndexCellMapping.cellID);
            }
        }
        return msOneStorePackage;
    }

    private CellManifestDataElementData findCellManifest(ExGuid cellMappingExtendedGUID) {
        return (CellManifestDataElementData)this.cellManifestDataElements.stream().filter((Predicate<DataElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findCellManifest$6(org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement ), (Lorg/apache/tika/parser/microsoft/onenote/fsshttpb/streamobj/DataElement;)Z)((ExGuid)cellMappingExtendedGUID)).findFirst().orElse((DataElement)new DataElement()).data;
    }

    private RevisionManifestDataElementData findRevisionManifestDataElement(ExGuid revisionMappingExtendedGUID) {
        return (RevisionManifestDataElementData)this.revisionManifestDataElements.stream().filter((Predicate<DataElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findRevisionManifestDataElement$7(org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement ), (Lorg/apache/tika/parser/microsoft/onenote/fsshttpb/streamobj/DataElement;)Z)((ExGuid)revisionMappingExtendedGUID)).findFirst().orElse((DataElement)new DataElement()).data;
    }

    private HeaderCell parseHeaderCell(RevisionManifestDataElementData headerCellRevisionManifest) throws IOException {
        ExGuid rootObjectId = headerCellRevisionManifest.revisionManifestObjectGroupReferences.get((int)0).objectGroupExtendedGUID;
        DataElement element = this.objectGroupDataElements.stream().filter(d -> d.dataElementExGuid.equals(rootObjectId)).findFirst().orElse(new DataElement());
        return HeaderCell.createInstance((ObjectGroupDataElementData)element.data);
    }

    private List<RevisionStoreObjectGroup> parseObjectGroup(CellID objectGroupCellID, MSOneStorePackage msOneStorePackage) throws IOException {
        StorageIndexCellMapping storageIndexCellMapping = msOneStorePackage.findStorageIndexCellMapping(objectGroupCellID);
        CellManifestDataElementData cellManifest = this.findCellManifest(storageIndexCellMapping.cellMappingExGuid);
        ArrayList<RevisionStoreObjectGroup> objectGroups = new ArrayList<RevisionStoreObjectGroup>();
        msOneStorePackage.cellManifests.add(cellManifest);
        StorageIndexRevisionMapping revisionMapping = msOneStorePackage.findStorageIndexRevisionMapping(cellManifest.cellManifestCurrentRevision.cellManifestCurrentRevisionExGuid);
        RevisionManifestDataElementData revisionManifest = this.findRevisionManifestDataElement(revisionMapping.revisionMappingExGuid);
        msOneStorePackage.revisionManifests.add(revisionManifest);
        RevisionManifestRootDeclare encryptionKeyRoot = revisionManifest.revisionManifestRootDeclareList.stream().filter(r -> r.rootExGuid.equals(new ExGuid(3, UUID.fromString("4A3717F8-1C14-49E7-9526-81D942DE1741")))).findFirst().orElse(null);
        boolean isEncryption = encryptionKeyRoot != null;
        for (RevisionManifestObjectGroupReferences objRef : revisionManifest.revisionManifestObjectGroupReferences) {
            ObjectGroupDataElementData dataObject = (ObjectGroupDataElementData)this.objectGroupDataElements.stream().filter((Predicate<DataElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$parseObjectGroup$10(org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestObjectGroupReferences org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement ), (Lorg/apache/tika/parser/microsoft/onenote/fsshttpb/streamobj/DataElement;)Z)((RevisionManifestObjectGroupReferences)objRef)).findFirst().get().data;
            RevisionStoreObjectGroup objectGroup = RevisionStoreObjectGroup.createInstance(objRef.objectGroupExtendedGUID, dataObject, isEncryption);
            objectGroups.add(objectGroup);
        }
        return objectGroups;
    }

    private static /* synthetic */ boolean lambda$parseObjectGroup$10(RevisionManifestObjectGroupReferences objRef, DataElement d) {
        return d.dataElementExGuid.equals(objRef.objectGroupExtendedGUID);
    }

    private static /* synthetic */ boolean lambda$findRevisionManifestDataElement$7(ExGuid revisionMappingExtendedGUID, DataElement d) {
        return d.dataElementExGuid.equals(revisionMappingExtendedGUID);
    }

    private static /* synthetic */ boolean lambda$findCellManifest$6(ExGuid cellMappingExtendedGUID, DataElement d) {
        return d.dataElementExGuid.equals(cellMappingExtendedGUID);
    }
}

