/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;

public class MemoryFeatureSet
extends AbstractFeatureSet {
    private final DefaultFeatureType type;
    private final Collection<AbstractFeature> features;

    public MemoryFeatureSet(StoreListeners storeListeners, DefaultFeatureType defaultFeatureType, Collection<AbstractFeature> collection) {
        super(storeListeners, false);
        ArgumentChecks.ensureNonNull((String)"type", (Object)defaultFeatureType);
        ArgumentChecks.ensureNonNull((String)"features", collection);
        this.type = defaultFeatureType;
        this.features = collection;
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    public OptionalLong getFeatureCount() {
        return OptionalLong.of(this.features.size());
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) {
        return bl ? this.features.parallelStream() : this.features.stream();
    }
}

