/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;

public class CatalogBase<C extends Context>
implements Catalog<C> {
    private final Map<String, Command<C>> commands;

    public CatalogBase() {
        this.commands = new ConcurrentHashMap<String, Command<C>>();
    }

    public CatalogBase(Map<String, Command<C>> commands) {
        this.commands = new ConcurrentHashMap<String, Command<C>>(commands);
    }

    @Override
    public <CMD extends Command<C>> void addCommand(String name, CMD command) {
        this.commands.put(name, command);
    }

    @Override
    public <CMD extends Command<C>> CMD getCommand(String name) {
        Command<C> command = this.commands.get(name);
        return (CMD)command;
    }

    @Override
    public Iterator<String> getNames() {
        return this.commands.keySet().iterator();
    }

    public String toString() {
        Iterator<String> names = this.getNames();
        StringBuilder str = new StringBuilder();
        str.append('[').append(this.getClass().getName()).append(": ");
        while (names.hasNext()) {
            str.append(names.next());
            if (!names.hasNext()) continue;
            str.append(", ");
        }
        str.append(']');
        return str.toString();
    }
}

