/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.BinaryFunction;
import org.apache.sis.filter.ConvertFunction;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

abstract class ArithmeticFunction<R>
extends BinaryFunction<R, Number, Number>
implements FeatureExpression<R, Number>,
Optimization.OnExpression<R, Number> {
    private static final long serialVersionUID = 2818625862630588268L;

    ArithmeticFunction(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
        super(expression, expression2);
    }

    static DefaultAttributeType<Number> createNumericType(String string) {
        return ArithmeticFunction.createType(Number.class, string);
    }

    protected abstract DefaultAttributeType<Number> expectedType();

    @Override
    public final Class<?> getValueClass() {
        return Number.class;
    }

    @Override
    public final PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        return featureTypeBuilder.addProperty(this.expectedType());
    }

    @Override
    public final Number apply(R r) {
        Number number;
        Number number2 = (Number)this.expression1.apply(r);
        if (number2 != null && (number = (Number)this.expression2.apply(r)) != null) {
            return this.apply(number2, number);
        }
        return null;
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> clazz) {
        if (clazz.isAssignableFrom(Number.class)) {
            return this;
        }
        try {
            return new ConvertFunction(this, Number.class, clazz);
        }
        catch (UnconvertibleObjectException unconvertibleObjectException) {
            throw (ClassCastException)new ClassCastException(Errors.format((short)8, (Object)this.getFunctionName(), clazz)).initCause(unconvertibleObjectException);
        }
    }

    static final class Divide<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = -7709291845568648891L;
        private static final DefaultAttributeType<Number> TYPE = Divide.createNumericType("Divide");
        private static final ScopedName NAME = Divide.createName("Divide");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Divide(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
            super(expression, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<? super R, ?>[] expressionArray) {
            return new Divide<R>(expressionArray[0].toValueType(Number.class), expressionArray[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u00f7';
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return d / d2;
        }

        @Override
        protected Number applyAsFraction(Fraction fraction, Fraction fraction2) {
            return fraction.divide(fraction2);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.divide(bigDecimal2);
        }

        @Override
        protected Number applyAsInteger(BigInteger bigInteger, BigInteger bigInteger2) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            if (BigInteger.ZERO.equals(bigIntegerArray[1])) {
                return bigIntegerArray[0];
            }
            return new Fraction(bigIntegerArray[1].intValueExact(), bigInteger2.intValueExact()).add(new Fraction(bigIntegerArray[0].intValueExact(), 1));
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            long l3 = l / l2;
            if (l % l2 == 0L) {
                return l3;
            }
            return new Fraction(Math.toIntExact(l), Math.toIntExact(l2));
        }
    }

    static final class Multiply<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = -1300022614832645625L;
        private static final DefaultAttributeType<Number> TYPE = Multiply.createNumericType("Multiply");
        private static final ScopedName NAME = Multiply.createName("Multiply");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Multiply(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
            super(expression, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<? super R, ?>[] expressionArray) {
            return new Multiply<R>(expressionArray[0].toValueType(Number.class), expressionArray[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u00d7';
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return d * d2;
        }

        @Override
        protected Number applyAsFraction(Fraction fraction, Fraction fraction2) {
            return fraction.multiply(fraction2);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.multiply(bigDecimal2);
        }

        @Override
        protected Number applyAsInteger(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.multiply(bigInteger2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return Math.multiplyExact(l, l2);
        }
    }

    static final class Subtract<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = 3048878022726271508L;
        private static final DefaultAttributeType<Number> TYPE = Subtract.createNumericType("Subtract");
        private static final ScopedName NAME = Subtract.createName("Subtract");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Subtract(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
            super(expression, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<? super R, ?>[] expressionArray) {
            return new Subtract<R>(expressionArray[0].toValueType(Number.class), expressionArray[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '\u2212';
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return d - d2;
        }

        @Override
        protected Number applyAsFraction(Fraction fraction, Fraction fraction2) {
            return fraction.subtract(fraction2);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.subtract(bigDecimal2);
        }

        @Override
        protected Number applyAsInteger(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.subtract(bigInteger2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return Math.subtractExact(l, l2);
        }
    }

    static final class Add<R>
    extends ArithmeticFunction<R> {
        private static final long serialVersionUID = 5445433312445869201L;
        private static final DefaultAttributeType<Number> TYPE = Add.createNumericType("Add");
        private static final ScopedName NAME = Add.createName("Add");

        @Override
        protected DefaultAttributeType<Number> expectedType() {
            return TYPE;
        }

        Add(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
            super(expression, expression2);
        }

        @Override
        public Expression<R, Number> recreate(Expression<? super R, ?>[] expressionArray) {
            return new Add<R>(expressionArray[0].toValueType(Number.class), expressionArray[1].toValueType(Number.class));
        }

        @Override
        public ScopedName getFunctionName() {
            return NAME;
        }

        @Override
        protected char symbol() {
            return '+';
        }

        @Override
        protected Number applyAsDouble(double d, double d2) {
            return d + d2;
        }

        @Override
        protected Number applyAsFraction(Fraction fraction, Fraction fraction2) {
            return fraction.add(fraction2);
        }

        @Override
        protected Number applyAsDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return bigDecimal.add(bigDecimal2);
        }

        @Override
        protected Number applyAsInteger(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger.add(bigInteger2);
        }

        @Override
        protected Number applyAsLong(long l, long l2) {
            return Math.addExact(l, l2);
        }
    }
}

