/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

public class CrawlableDatasetUtils {
    public static String[] getPathSegments(String path) {
        return (path == null ? "" : path).split("/");
    }

    public static String getPath(String[] pathSegments) {
        if (pathSegments == null) {
            return "";
        }
        int start = 0;
        StringBuilder sb = new StringBuilder();
        if (CrawlableDatasetUtils.isValidAbsolutePath(pathSegments)) {
            if (pathSegments.length == 0) {
                return "/";
            }
            sb.append("/").append(pathSegments[1]);
            start = 2;
        } else if (CrawlableDatasetUtils.isValidRelativePath(pathSegments)) {
            sb.append(pathSegments[0]);
            start = 1;
            if (pathSegments.length == 1) {
                return pathSegments[0];
            }
        } else {
            throw new IllegalArgumentException(String.format("Path segment array [%s] not valid path.", CrawlableDatasetUtils.toStringForPathSegments(pathSegments)));
        }
        for (int i = start; i < pathSegments.length; ++i) {
            sb.append("/").append(pathSegments[i]);
        }
        return sb.toString();
    }

    public static boolean isValidAbsolutePath(String[] pathSegments) {
        if (pathSegments == null) {
            return false;
        }
        if (pathSegments.length == 0) {
            return true;
        }
        return pathSegments.length > 1 && pathSegments[0].isEmpty();
    }

    public static boolean isValidRelativePath(String[] pathSegments) {
        return pathSegments != null && pathSegments.length > 0 && !pathSegments[0].isEmpty();
    }

    public static String stepDownRelativePath(String[] pathSegments) {
        if (!CrawlableDatasetUtils.isValidRelativePath(pathSegments)) {
            throw new IllegalArgumentException("Path segments not a valid relative path.");
        }
        if (pathSegments.length < 2) {
            throw new IllegalArgumentException("Number of path segments must be > 1.");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < pathSegments.length - 1; ++i) {
            sb.append(pathSegments[i]).append("/");
        }
        sb.append(pathSegments[pathSegments.length - 1]);
        return sb.toString();
    }

    public static String toStringForPathSegments(String[] pathSegments) {
        StringBuilder sb = new StringBuilder();
        if (CrawlableDatasetUtils.isValidAbsolutePath(pathSegments)) {
            sb.append("Absolute: ");
        } else if (CrawlableDatasetUtils.isValidRelativePath(pathSegments)) {
            sb.append("Relative: ");
        } else {
            sb.append("Invalid: ");
            if (pathSegments == null) {
                return sb.append("null").toString();
            }
        }
        for (String curPathSegment : pathSegments) {
            sb.append("[").append(curPathSegment).append("]");
        }
        return sb.toString();
    }

    public static String toStringForPathSegments(String path) {
        String[] pathSegments = CrawlableDatasetUtils.getPathSegments(path);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Path [%s] as %d segments: ", path, pathSegments.length));
        for (String pathSegment : pathSegments) {
            sb.append("[").append(pathSegment).append("]");
        }
        sb.append(" - valid abs[").append(CrawlableDatasetUtils.isValidAbsolutePath(pathSegments)).append("] rel[").append(CrawlableDatasetUtils.isValidRelativePath(pathSegments)).append("]");
        return sb.toString();
    }
}

