/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.FactoryException;

class DatumShiftGridLoader {
    static final double DEGREES_TO_SECONDS = 3600.0;
    static final double SECOND_PRECISION = 1.0E-4;
    final Path file;
    private final ReadableByteChannel channel;
    final ByteBuffer buffer;
    private static final AtomicBoolean datumDirectoryLogged = new AtomicBoolean();

    DatumShiftGridLoader(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, Path path) throws IOException {
        this.file = path;
        this.buffer = byteBuffer;
        this.channel = readableByteChannel;
        readableByteChannel.read(byteBuffer);
        byteBuffer.flip();
    }

    final void ensureBufferContains(int n) throws IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int n2;
            this.buffer.compact();
            do {
                if ((n2 = this.channel.read(this.buffer)) > 0) continue;
                if (n2 != 0) {
                    throw new EOFException(Errors.format((short)137, (Object)this.file));
                }
                throw new IOException(Errors.format((short)12, (Object)this.file));
            } while ((n -= n2) > 0);
            this.buffer.flip();
        }
    }

    final void skip(int n) throws IOException {
        int n2;
        while ((n2 = this.buffer.position() + n) > this.buffer.limit()) {
            this.buffer.clear();
            this.ensureBufferContains(Math.min(n -= this.buffer.remaining(), this.buffer.capacity()));
        }
        this.buffer.position(n2);
    }

    static void startLoading(Class<?> clazz, Object object) {
        DatumShiftGridLoader.log(clazz, Resources.forLocale(null).getLogRecord(Level.FINE, (short)32, object));
    }

    static void log(Class<?> clazz, LogRecord logRecord) {
        logRecord.setLoggerName("org.apache.sis.referencing.operation");
        Logging.log(clazz, (String)"createMathTransform", (LogRecord)logRecord);
    }

    static FactoryException canNotLoad(String string, Path path, Exception exception) {
        boolean bl;
        Object object;
        Path path2;
        if (!datumDirectoryLogged.get() && (path2 = DataDirectory.DATUM_CHANGES.getDirectory()) != null && !datumDirectoryLogged.getAndSet(true)) {
            object = Resources.forLocale(null).getLogRecord(Level.INFO, (short)92, path2);
            ((LogRecord)object).setLoggerName("org.apache.sis.referencing.operation");
            Logging.log(DatumShiftGridLoader.class, (String)"readGrid", (LogRecord)object);
        }
        object = Resources.format((bl = exception instanceof NoSuchFileException) ? (short)90 : 91, string, path);
        if (bl) {
            return new MissingFactoryResourceException((String)object, exception);
        }
        return new FactoryDataException((String)object, exception);
    }
}

