/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.identification.BrowseGraphic;

@XmlType(name="CI_Organisation_Type", propOrder={"logo", "individual"})
@XmlRootElement(name="CI_Organisation")
@UML(identifier="CI_Organisation", specification=Specification.ISO_19115)
public class DefaultOrganisation
extends AbstractParty {
    private static final long serialVersionUID = 5113656476176154532L;
    private Collection<BrowseGraphic> logo;
    private Collection<DefaultIndividual> individual;

    public DefaultOrganisation() {
    }

    public DefaultOrganisation(CharSequence charSequence, BrowseGraphic browseGraphic, DefaultIndividual defaultIndividual, Contact contact) {
        super(charSequence, contact);
        this.logo = this.singleton(browseGraphic, BrowseGraphic.class);
        this.individual = this.singleton(defaultIndividual, DefaultIndividual.class);
    }

    public DefaultOrganisation(DefaultOrganisation defaultOrganisation) {
        super(defaultOrganisation);
        if (defaultOrganisation != null) {
            this.logo = this.copyCollection(defaultOrganisation.getLogo(), BrowseGraphic.class);
            this.individual = this.copyCollection(defaultOrganisation.getIndividual(), DefaultIndividual.class);
        }
    }

    @XmlElement(name="logo")
    @UML(identifier="logo", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<BrowseGraphic> getLogo() {
        this.logo = this.nonNullCollection(this.logo, BrowseGraphic.class);
        return this.logo;
    }

    public void setLogo(Collection<? extends BrowseGraphic> collection) {
        this.logo = this.writeCollection(collection, this.logo, BrowseGraphic.class);
    }

    @XmlElement(name="individual")
    @UML(identifier="individual", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultIndividual> getIndividual() {
        this.individual = this.nonNullCollection(this.individual, DefaultIndividual.class);
        return this.individual;
    }

    public void setIndividual(Collection<? extends DefaultIndividual> collection) {
        this.individual = this.writeCollection(collection, this.individual, DefaultIndividual.class);
    }
}

