/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public final class RandomAccessInputStream
extends InputStream {
    private static final int BLOCK_SIZE = 512;
    private static final int BLOCK_MASK = 511;
    private static final int BLOCK_SHIFT = 9;
    private final InputStream src;
    private long pointer = 0L;
    private final Vector data = new Vector();
    private int length = 0;
    private boolean foundEOS = false;

    public RandomAccessInputStream(InputStream inputstream) {
        this.src = inputstream;
    }

    public int getFilePointer() throws IOException {
        return (int)this.pointer;
    }

    public long getLongFilePointer() throws IOException {
        return this.pointer;
    }

    @Override
    public int read() throws IOException {
        long l = this.pointer + 1L;
        long l1 = this.readUntil(l);
        if (l1 >= l) {
            byte[] abyte0 = (byte[])this.data.elementAt((int)(this.pointer >>> 9));
            return abyte0[(int)(this.pointer++ & 0x1FFL)] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)len);
        if (l <= this.pointer) {
            return -1;
        }
        byte[] abyte1 = (byte[])this.data.elementAt((int)(this.pointer >>> 9));
        int k = Math.min(len, 512 - (int)(this.pointer & 0x1FFL));
        System.arraycopy(abyte1, (int)(this.pointer & 0x1FFL), bytes, off, k);
        this.pointer += (long)k;
        return k;
    }

    public void readFully(byte[] bytes) throws IOException {
        this.readFully(bytes, bytes.length);
    }

    public void readFully(byte[] bytes, int len) throws IOException {
        int l;
        int read = 0;
        while ((l = this.read(bytes, read, len - read)) >= 0 && (read += l) < len) {
        }
    }

    private long readUntil(long l) throws IOException {
        int j;
        if (l < (long)this.length) {
            return l;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int i = (int)(l >>> 9);
        for (int k = j = this.length >>> 9; k <= i; ++k) {
            byte[] abyte0 = new byte[512];
            this.data.addElement(abyte0);
            int i1 = 512;
            int j1 = 0;
            while (i1 > 0) {
                int k1 = this.src.read(abyte0, j1, i1);
                if (k1 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                j1 += k1;
                i1 -= k1;
                this.length += k1;
            }
        }
        return this.length;
    }

    public void seek(long loc) throws IOException {
        this.pointer = loc < 0L ? 0L : loc;
    }

    public void seek(int loc) throws IOException {
        long lloc = (long)loc & 0xFFFFFFFFL;
        this.pointer = lloc < 0L ? 0L : lloc;
    }

    public int readInt() throws IOException {
        int l;
        int k;
        int j;
        int i = this.read();
        if ((i | (j = this.read()) | (k = this.read()) | (l = this.read())) < 0) {
            throw new EOFException();
        }
        return (i << 24) + (j << 16) + (k << 8) + l;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public short readShort() throws IOException {
        int j;
        int i = this.read();
        if ((i | (j = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((i << 8) + j);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void close() throws IOException {
        this.data.removeAllElements();
        this.src.close();
    }
}

