/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.sql.SQLException;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.Resources;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;

public final class ServicesForUtility
extends MetadataServices {
    public boolean isUnmarshalling() {
        Context context = Context.current();
        return context != null && !Context.isFlagSet(context, 1);
    }

    public String getCodeTitle(CodeList<?> codeList, Locale locale) {
        return Types.getCodeTitle(codeList).toString(locale);
    }

    public String getUnicodeIdentifier(Citation citation) {
        return Identifiers.getIdentifier(citation, true);
    }

    public String getInformation(String string, Locale locale) {
        switch (string) {
            case "DataSource": {
                Object object = null;
                Object object2 = null;
                try {
                    DataSource dataSource = Initializer.getDataSource();
                    if (dataSource != null) {
                        Class<?> clazz = dataSource.getClass();
                        object2 = clazz.getMethod("getDatabaseName", null).invoke((Object)dataSource, (Object[])null);
                        object = clazz.getMethod("getServerName", null).invoke((Object)dataSource, (Object[])null);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.system"), MetadataServices.class, (String)"getInformation", (Throwable)noSuchMethodException);
                }
                catch (Exception exception) {
                    String string2 = Exceptions.getLocalizedMessage((Throwable)exception, (Locale)locale);
                    if (string2 == null || string2.indexOf(32) < 0) {
                        string2 = Classes.getShortClassName((Object)exception) + ": " + string2;
                    }
                    return string2;
                }
                if (object2 != null) {
                    if (object != null) {
                        object2 = "//" + object + '/' + object2;
                    }
                    return object2.toString();
                }
                return null;
            }
        }
        return ReferencingServices.getInstance().getInformation(string, locale);
    }

    public Format createCoordinateFormat(Locale locale, TimeZone timeZone) {
        return ReferencingServices.getInstance().createCoordinateFormat(locale, timeZone);
    }

    public DataSource getDataSource() throws SQLException {
        try {
            return Initializer.getDataSource();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(Errors.format((short)6, (Object)"SpatialMetadata"), exception);
        }
    }

    public void setDataSource(Supplier<DataSource> supplier) {
        if (!Initializer.setDefault(supplier)) {
            throw new IllegalStateException(Resources.format((short)6, "SpatialMetadata"));
        }
    }
}

