/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.core.value.ReadableBinaryValue;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class BaseValue
implements ExtendedValue,
ReadableBinaryValue {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.BaseValue");
    protected final int type;
    protected ValueData internalData;
    protected boolean streamConsumed;
    protected boolean bytesConsumed;
    protected InputStream stream;

    BaseValue(int type, ValueData data) {
        this.type = type;
        this.internalData = data;
    }

    public final int getType() {
        return this.type;
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.validateByteArrayMethodInvoking();
        return ValueDataUtil.getDate(this.getInternalData());
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.validateByteArrayMethodInvoking();
        try {
            return ValueDataUtil.getLong(this.getInternalData());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("Can't convert to Long value");
        }
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.validateByteArrayMethodInvoking();
        return ValueDataUtil.getBoolean(this.getInternalData());
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.validateByteArrayMethodInvoking();
        try {
            return ValueDataUtil.getDouble(this.getInternalData());
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("Can't convert to Long value");
        }
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        this.validateStreamMethodInvoking();
        try {
            if (this.stream == null) {
                this.stream = this.getAsStream();
            }
            return this.stream;
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.validateByteArrayMethodInvoking();
        return ValueDataUtil.getString(this.getInternalData());
    }

    @Override
    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.validateByteArrayMethodInvoking();
        return ValueDataUtil.getReference(this.getInternalData());
    }

    @Override
    public long getLength() {
        return this.getInternalData().getLength();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        if (obj instanceof BaseValue) {
            return this.getInternalData().equals(((BaseValue)obj).getInternalData());
        }
        return false;
    }

    @Override
    public int getOrderNumber() {
        return this.getInternalData().getOrderNumber();
    }

    @Override
    public long read(OutputStream stream, long length, long position) throws IOException, RepositoryException {
        return this.getInternalData().read(stream, length, position);
    }

    public String toString() {
        Object info;
        String typeName;
        try {
            typeName = PropertyType.nameFromValue((int)this.type);
        }
        catch (IllegalArgumentException e) {
            typeName = String.valueOf(this.type);
        }
        if (this.type == 2) {
            info = "size: " + (String)(this.getInternalData() == null ? "undefined" : this.getInternalData().getLength() + " bytes");
        } else {
            try {
                info = "value: '" + this.getString() + "'";
            }
            catch (IllegalStateException e) {
                info = "can't retrieve value";
            }
            catch (RepositoryException e) {
                info = "can't retrieve value";
            }
        }
        return String.format("Value {\n type: %s;\n data-class: %s;\n %s\n}", typeName, this.getInternalData() == null ? null : this.internalData.getClass().getName(), info);
    }

    public ValueData getInternalData() {
        return this.internalData;
    }

    protected InputStream getAsStream() throws IOException, ValueFormatException, IllegalStateException, RepositoryException {
        return this.getInternalData().getAsStream();
    }

    protected void validateStreamMethodInvoking() throws IllegalStateException {
        if (this.streamConsumed) {
            throw new IllegalStateException("non-stream value has already been consumed");
        }
        this.bytesConsumed = true;
    }

    protected void validateByteArrayMethodInvoking() throws IllegalStateException {
        if (this.bytesConsumed) {
            throw new IllegalStateException("non-stream value has already been consumed");
        }
        this.streamConsumed = true;
    }

    protected void invalidateStream() {
        this.stream = null;
    }
}

