/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Indexer {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.Indexer");
    private final SearchManager searchManager;
    private final SearchManager parentSearchManager;
    private final QueryHandler handler;
    private final QueryHandler parentHandler;

    public Indexer(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.searchManager = searchManager;
        this.parentSearchManager = parentSearchManager;
        this.handler = handler;
        this.parentHandler = parentHandler;
    }

    public void updateIndex(Set<String> addedNodes, Set<String> removedNodes, Set<String> parentAddedNodes, Set<String> parentRemovedNodes) {
        if (this.searchManager != null && (addedNodes.size() > 0 || removedNodes.size() > 0)) {
            try {
                this.searchManager.updateIndex(removedNodes, addedNodes);
            }
            catch (RepositoryException e) {
                log.error((Object)("Error indexing changes " + String.valueOf((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
                try {
                    this.handler.logErrorChanges(removedNodes, addedNodes);
                }
                catch (IOException ioe) {
                    log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + String.valueOf(ioe)), (Throwable)ioe);
                }
            }
        }
        if (this.parentSearchManager != null && (parentAddedNodes.size() > 0 || parentRemovedNodes.size() > 0)) {
            try {
                this.parentSearchManager.updateIndex(parentRemovedNodes, parentAddedNodes);
            }
            catch (RepositoryException e) {
                log.error((Object)("Error indexing changes " + String.valueOf((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
                try {
                    this.parentHandler.logErrorChanges(parentRemovedNodes, parentAddedNodes);
                }
                catch (IOException ioe) {
                    log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + String.valueOf(ioe)), (Throwable)ioe);
                }
            }
        }
    }

    public void updateIndex(ChangesHolder changes, ChangesHolder parentChanges) {
        if (this.searchManager != null && changes != null) {
            try {
                this.searchManager.apply(changes);
            }
            catch (RepositoryException e) {
                log.error((Object)("Error indexing changes " + String.valueOf((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
                try {
                    this.handler.logErrorChanges(new HashSet<String>(changes.getRemove()), new HashSet<String>(changes.getAddIds()));
                }
                catch (IOException ioe) {
                    log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + String.valueOf(ioe)), (Throwable)ioe);
                }
            }
        }
        if (this.parentSearchManager != null && parentChanges != null) {
            try {
                this.parentSearchManager.apply(parentChanges);
            }
            catch (RepositoryException e) {
                log.error((Object)("Error indexing changes " + String.valueOf((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
                try {
                    this.parentHandler.logErrorChanges(new HashSet<String>(parentChanges.getRemove()), new HashSet<String>(parentChanges.getAddIds()));
                }
                catch (IOException ioe) {
                    log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + String.valueOf(ioe)), (Throwable)ioe);
                }
            }
        }
    }
}

