/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xml.XMLParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FictionBookParser
extends XMLParser {
    private static final long serialVersionUID = 4195954546491524374L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-fictionbook+xml"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        return new BinaryElementsDataHandler(EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context), handler);
    }

    private static class BinaryElementsDataHandler
    extends DefaultHandler {
        private static final String ELEMENT_BINARY = "binary";
        private boolean binaryMode = false;
        private static final String ATTRIBUTE_ID = "id";
        private final EmbeddedDocumentExtractor partExtractor;
        private final ContentHandler handler;
        private final StringBuilder binaryData = new StringBuilder();
        private Metadata metadata;
        private static final String ATTRIBUTE_CONTENT_TYPE = "content-type";

        private BinaryElementsDataHandler(EmbeddedDocumentExtractor partExtractor, ContentHandler handler) {
            this.partExtractor = partExtractor;
            this.handler = handler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.binaryMode = ELEMENT_BINARY.equals(localName);
            if (this.binaryMode) {
                this.binaryData.setLength(0);
                this.metadata = new Metadata();
                this.metadata.set("resourceName", attributes.getValue(ATTRIBUTE_ID));
                this.metadata.set("Content-Type", attributes.getValue(ATTRIBUTE_CONTENT_TYPE));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.binaryMode) {
                try {
                    this.partExtractor.parseEmbedded((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)this.binaryData.toString())), this.handler, this.metadata, true);
                }
                catch (IOException e) {
                    throw new SAXException("IOException in parseEmbedded", e);
                }
                this.binaryMode = false;
                this.binaryData.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.binaryMode) {
                this.handler.characters(ch, start, length);
            } else {
                this.binaryData.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.handler.ignorableWhitespace(ch, start, length);
        }
    }
}

