/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Immutables;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClearCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.TimeService;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public static final Address LOCAL_MODE_ADDRESS = new Address(){

        public String toString() {
            return "Local Address";
        }

        @Override
        public int compareTo(Address o) {
            return 0;
        }
    };

    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public Address getPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, Metadata var2, FlagAffectedCommand var3, InvocationContext var4, Flag var5, boolean var6);

    public List<Address> getOwners(Collection<Object> var1);

    public List<Address> getOwners(Object var1);

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static class DistributionLogic
    extends AbstractClusteringDependentLogic {
        private DistributionManager dm;
        private Configuration configuration;
        private RpcManager rpcManager;
        private StateTransferLock stateTransferLock;

        @Inject
        public void init(DistributionManager dm, Configuration configuration, RpcManager rpcManager, StateTransferLock stateTransferLock) {
            this.dm = dm;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
            this.stateTransferLock = stateTransferLock;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            Address address = this.rpcManager.getAddress();
            return this.dm.getPrimaryLocation(key).equals(address);
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.dm.getPrimaryLocation(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void commitSingleEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                boolean isForeignOwned;
                boolean doCommit = true;
                boolean skipOwnershipCheck = command != null && command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK);
                boolean bl = isForeignOwned = !skipOwnershipCheck && !this.localNodeIsOwner(entry.getKey());
                if (isForeignOwned && !entry.isRemoved()) {
                    if (this.configuration.clustering().l1().enabled()) {
                        long lifespan = metadata != null ? metadata.lifespan() : entry.getLifespan();
                        if (lifespan < 0L || lifespan > this.configuration.clustering().l1().lifespan()) {
                            Metadata.Builder builder = metadata != null ? metadata.builder() : entry.getMetadata().builder();
                            metadata = builder.lifespan(this.configuration.clustering().l1().lifespan()).build();
                            metadata = new L1Metadata(metadata);
                        }
                    } else {
                        doCommit = false;
                    }
                }
                boolean created = false;
                boolean removed = false;
                boolean expired = false;
                if (!isForeignOwned) {
                    created = entry.isCreated();
                    removed = entry.isRemoved();
                    if (removed && entry instanceof MVCCEntry) {
                        expired = ((MVCCEntry)entry).isExpired();
                    }
                }
                if (doCommit) {
                    InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
                    Object previousValue = null;
                    Metadata previousMetadata = null;
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    this.commitManager.commit(entry, metadata, trackFlag, l1Invalidation);
                    if (!isForeignOwned) {
                        this.notifyCommitEntry(created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
                    }
                } else {
                    entry.rollback();
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        public List<Address> getOwners(Collection<Object> affectedKeys) {
            if (affectedKeys.isEmpty()) {
                return Collections.emptyList();
            }
            return Immutables.immutableListConvert(this.dm.locateAll(affectedKeys));
        }

        @Override
        public List<Address> getOwners(Object key) {
            return Immutables.immutableListConvert(this.dm.locate(key));
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return this.localNodeIsOwner(key);
                }
            } : new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return this.localNodeIsPrimaryOwner(key);
                }
            };
        }
    }

    public static class ReplicationLogic
    extends InvalidationLogic {
        private StateTransferLock stateTransferLock;

        @Inject
        public void init(StateTransferLock stateTransferLock) {
            this.stateTransferLock = stateTransferLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void commitSingleEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                super.commitSingleEntry(entry, metadata, command, ctx, trackFlag, l1Invalidation);
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return true;
                }
            } : new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return this.localNodeIsPrimaryOwner(key);
                }
            };
        }
    }

    public static class InvalidationLogic
    extends AbstractClusteringDependentLogic {
        private StateTransferManager stateTransferManager;
        private RpcManager rpcManager;

        @Inject
        public void init(RpcManager rpcManager, StateTransferManager stateTransferManager) {
            this.rpcManager = rpcManager;
            this.stateTransferManager = stateTransferManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key);
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().locatePrimaryOwner(key).equals(this.rpcManager.getAddress());
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().locatePrimaryOwner(key);
        }

        @Override
        protected void commitSingleEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
            InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
            Object previousValue = null;
            Metadata previousMetadata = null;
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            }
            this.commitManager.commit(entry, metadata, trackFlag, l1Invalidation);
            this.notifyCommitEntry(created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
        }

        @Override
        public List<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public List<Address> getOwners(Object key) {
            return null;
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return null;
        }
    }

    public static class LocalLogic
    extends AbstractClusteringDependentLogic {
        private EmbeddedCacheManager cacheManager;

        @Inject
        public void init(EmbeddedCacheManager cacheManager) {
            this.cacheManager = cacheManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return true;
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            throw new IllegalStateException("Cannot invoke this method for local caches");
        }

        @Override
        public List<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public List<Address> getOwners(Object key) {
            return null;
        }

        @Override
        public Address getAddress() {
            Address address = this.cacheManager.getAddress();
            if (address == null) {
                address = LOCAL_MODE_ADDRESS;
            }
            return address;
        }

        @Override
        protected void commitSingleEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
            InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
            Object previousValue = null;
            Metadata previousMetadata = null;
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            }
            this.commitManager.commit(entry, metadata, trackFlag, l1Invalidation);
            this.notifyCommitEntry(created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            throw new IllegalStateException("Cannot invoke this method for local caches");
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return null;
        }
    }

    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic {
        protected DataContainer<Object, Object> dataContainer;
        protected CacheNotifier<Object, Object> notifier;
        protected boolean totalOrder;
        private WriteSkewHelper.KeySpecificLogic keySpecificLogic;
        protected CommitManager commitManager;
        protected PersistenceManager persistenceManager;
        protected TimeService timeService;
        protected FunctionalNotifier<Object, Object> functionalNotifier;

        @Inject
        public void init(DataContainer<Object, Object> dataContainer, CacheNotifier<Object, Object> notifier, Configuration configuration, CommitManager commitManager, PersistenceManager persistenceManager, TimeService timeService, FunctionalNotifier<Object, Object> functionalNotifier) {
            this.dataContainer = dataContainer;
            this.notifier = notifier;
            this.totalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
            this.keySpecificLogic = this.initKeySpecificLogic(this.totalOrder);
            this.commitManager = commitManager;
            this.persistenceManager = persistenceManager;
            this.timeService = timeService;
            this.functionalNotifier = functionalNotifier;
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            return this.totalOrder ? this.totalOrderCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand) : this.clusteredCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand);
        }

        @Override
        public final void commitEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            if (entry instanceof ClearCacheEntry) {
                this.commitClearCommand(this.dataContainer, (ClearCacheEntry)entry, ctx, command);
            } else {
                this.commitSingleEntry(entry, metadata, command, ctx, trackFlag, l1Invalidation);
            }
        }

        private void commitClearCommand(DataContainer<Object, Object> dataContainer, ClearCacheEntry<Object, Object> cacheEntry, InvocationContext context, FlagAffectedCommand command) {
            ArrayList<InternalCacheEntry<Object, Object>> copyEntries = new ArrayList<InternalCacheEntry<Object, Object>>(dataContainer.entrySet());
            cacheEntry.commit(dataContainer, null);
            for (InternalCacheEntry internalCacheEntry : copyEntries) {
                this.notifier.notifyCacheEntryRemoved(internalCacheEntry.getKey(), internalCacheEntry.getValue(), internalCacheEntry.getMetadata(), false, context, command);
            }
        }

        protected abstract void commitSingleEntry(CacheEntry var1, Metadata var2, FlagAffectedCommand var3, InvocationContext var4, Flag var5, boolean var6);

        protected abstract WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean var1);

        protected void notifyCommitEntry(boolean created, boolean removed, boolean expired, CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Object previousValue, Metadata previousMetadata) {
            boolean isWriteOnly;
            boolean bl = isWriteOnly = command instanceof WriteCommand && ((WriteCommand)command).isWriteOnly();
            if (removed) {
                if (command instanceof RemoveCommand) {
                    ((RemoveCommand)command).notify(ctx, previousValue, previousMetadata, false);
                } else {
                    if (expired) {
                        this.notifier.notifyCacheEntryExpired(entry.getKey(), previousValue, previousMetadata, ctx);
                    } else {
                        this.notifier.notifyCacheEntryRemoved(entry.getKey(), previousValue, previousMetadata, false, ctx, command);
                    }
                    if (!isWriteOnly) {
                        this.functionalNotifier.notifyOnRemove(EntryViews.readOnly(entry.getKey(), previousValue, previousMetadata));
                    }
                    this.functionalNotifier.notifyOnWrite(() -> EntryViews.noValue(entry.getKey()));
                }
            } else if (created) {
                this.notifier.notifyCacheEntryCreated(entry.getKey(), entry.getValue(), entry.getMetadata(), false, ctx, command);
                if (!isWriteOnly) {
                    this.functionalNotifier.notifyOnCreate(EntryViews.readOnly(entry));
                }
                this.functionalNotifier.notifyOnWrite(() -> EntryViews.readOnly(entry));
            } else {
                this.notifier.notifyCacheEntryModified(entry.getKey(), entry.getValue(), entry.getMetadata(), previousValue, previousMetadata, false, ctx, command);
                if (!isWriteOnly) {
                    this.functionalNotifier.notifyOnModify(EntryViews.readOnly(entry.getKey(), previousValue, previousMetadata), EntryViews.readOnly(entry));
                }
                this.functionalNotifier.notifyOnWrite(() -> EntryViews.readOnly(entry));
            }
        }

        private EntryVersionsMap totalOrderCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (context.isOriginLocal()) {
                throw new IllegalStateException("This must not be reached");
            }
            EntryVersionsMap updatedVersionMap = new EntryVersionsMap();
            if (!((TotalOrderPrepareCommand)((Object)prepareCommand)).skipWriteSkewCheck()) {
                updatedVersionMap = WriteSkewHelper.performTotalOrderWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, this.persistenceManager, versionGenerator, context, this.keySpecificLogic, this.timeService);
            }
            for (WriteCommand c : prepareCommand.getModifications()) {
                for (Object k : c.getAffectedKeys()) {
                    if (!this.keySpecificLogic.performCheckOnKey(k) || updatedVersionMap.containsKey(k)) continue;
                    updatedVersionMap.put(k, null);
                }
            }
            ((AbstractCacheTransaction)context.getCacheTransaction()).setUpdatedEntryVersions(updatedVersionMap);
            return updatedVersionMap;
        }

        private EntryVersionsMap clusteredCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, this.persistenceManager, versionGenerator, context, this.keySpecificLogic, this.timeService);
            Object cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }
    }
}

