/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xliff;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.xliff.XLIFF12ContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XLIFF12Parser
extends AbstractParser {
    private static final long serialVersionUID = 1490085649251663857L;
    private static final MediaType XLF_CONTENT_TYPE = MediaType.application((String)"x-xliff+xml");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(XLF_CONTENT_TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", XLF_CONTENT_TYPE.toString());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new XLIFF12ContentHandler(xhtml, metadata)), (ParseContext)context);
    }
}

