/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;

public class ItemDataKeeperAdapter
implements ItemDataKeeper {
    private final SessionDataManager sessionDataManager;

    public ItemDataKeeperAdapter(SessionDataManager sessionDataManager) {
        this.sessionDataManager = sessionDataManager;
    }

    @Override
    public void save(ItemStateChangesLog changes) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        for (ItemState itemState : changes.getAllStates()) {
            if (itemState.isAdded()) {
                this.sessionDataManager.update(itemState, false);
                continue;
            }
            if (!itemState.isDeleted()) continue;
            this.sessionDataManager.delete(itemState.getData(), itemState.getAncestorToSave());
        }
    }
}

