/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.version;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.util.IdGenerator;

public class VersionHistoryDataHelper
extends TransientNodeData {
    protected final ItemDataConsumer dataManager;
    protected final NodeTypeDataManager ntManager;
    private final String versionHistoryIdentifier;
    private final String baseVersionIdentifier;

    public VersionHistoryDataHelper(NodeData source, ItemDataConsumer dataManager, NodeTypeDataManager ntManager) {
        super(source.getQPath(), source.getIdentifier(), source.getPersistedVersion(), source.getPrimaryTypeName(), source.getMixinTypeNames(), source.getOrderNumber(), source.getParentIdentifier(), source.getACL());
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.versionHistoryIdentifier = IdGenerator.generate();
        this.baseVersionIdentifier = IdGenerator.generate();
    }

    public VersionHistoryDataHelper(NodeData versionable, PlainChangesLog changes, ItemDataConsumer dataManager, NodeTypeDataManager ntManager) throws RepositoryException {
        this(versionable, changes, dataManager, ntManager, IdGenerator.generate(), IdGenerator.generate());
    }

    public VersionHistoryDataHelper(NodeData versionable, PlainChangesLog changes, ItemDataConsumer dataManager, NodeTypeDataManager ntManager, String versionHistoryIdentifier, String baseVersionIdentifier) throws RepositoryException {
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.versionHistoryIdentifier = versionHistoryIdentifier;
        this.baseVersionIdentifier = baseVersionIdentifier;
        TransientNodeData vh = this.init(versionable, changes);
        this.parentIdentifier = vh.getParentIdentifier();
        this.identifier = vh.getIdentifier();
        this.qpath = vh.getQPath();
        this.persistedVersion = vh.getPersistedVersion();
        this.primaryTypeName = vh.getPrimaryTypeName();
        this.mixinTypeNames = vh.getMixinTypeNames();
        this.orderNum = vh.getOrderNumber();
        this.acl = vh.getACL();
    }

    public List<NodeData> getAllVersionsData() throws RepositoryException {
        NodeData vData = (NodeData)this.dataManager.getItemData(this.getIdentifier());
        NodeData rootVersion = (NodeData)this.dataManager.getItemData(vData, new QPathEntry(Constants.JCR_ROOTVERSION, 0), ItemType.NODE);
        ArrayList<NodeData> vChilds = new ArrayList<NodeData>();
        vChilds.add(rootVersion);
        for (NodeData cnd : this.dataManager.getChildNodesData(vData)) {
            if (cnd.getQPath().getName().equals((Object)Constants.JCR_ROOTVERSION) || !this.ntManager.isNodeType(Constants.NT_VERSION, cnd.getPrimaryTypeName())) continue;
            vChilds.add(cnd);
        }
        return vChilds;
    }

    public NodeData getLastVersionData() throws RepositoryException {
        List<NodeData> versionsData = this.getAllVersionsData();
        NodeData lastVersionData = null;
        Calendar lastCreated = null;
        for (NodeData vd : versionsData) {
            PropertyData createdData = (PropertyData)this.dataManager.getItemData(vd, new QPathEntry(Constants.JCR_CREATED, 0), ItemType.PROPERTY);
            if (createdData == null) {
                throw new VersionException("jcr:created is not found, version: " + vd.getQPath().getAsString());
            }
            Calendar created = JCRDateFormat.parse(ValueDataUtil.getString(createdData.getValues().get(0)));
            if (lastVersionData != null && !created.after(lastCreated)) continue;
            lastCreated = created;
            lastVersionData = vd;
        }
        return lastVersionData;
    }

    public NodeData getVersionData(InternalQName versionQName) throws VersionException, RepositoryException {
        return (NodeData)this.dataManager.getItemData(this, new QPathEntry(versionQName, 0), ItemType.NODE);
    }

    public NodeData getVersionLabelsData() throws VersionException, RepositoryException {
        return (NodeData)this.dataManager.getItemData(this, new QPathEntry(Constants.JCR_VERSIONLABELS, 0), ItemType.NODE);
    }

    public List<PropertyData> getVersionLabels() throws VersionException, RepositoryException {
        List<PropertyData> labelsList = this.dataManager.getChildPropertiesData(this.getVersionLabelsData());
        return labelsList;
    }

    public NodeData getVersionDataByLabel(InternalQName labelQName) throws VersionException, RepositoryException {
        List<PropertyData> labelsList = this.getVersionLabels();
        for (PropertyData prop : labelsList) {
            if (!prop.getQPath().getName().equals((Object)labelQName)) continue;
            try {
                String versionIdentifier = ValueDataUtil.getString(prop.getValues().get(0));
                return (NodeData)this.dataManager.getItemData(versionIdentifier);
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("Version label data error: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private TransientNodeData init(NodeData versionable, PlainChangesLog changes) throws RepositoryException {
        NodeData rootItem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
        NodeData versionStorageData = (NodeData)this.dataManager.getItemData(rootItem, new QPathEntry(Constants.JCR_VERSIONSTORAGE, 1), ItemType.NODE);
        if (!(versionStorageData instanceof TransientNodeData)) {
            versionStorageData = new TransientNodeData(versionStorageData.getQPath(), versionStorageData.getIdentifier(), versionStorageData.getPersistedVersion(), versionStorageData.getPrimaryTypeName(), versionStorageData.getMixinTypeNames(), versionStorageData.getOrderNumber(), versionStorageData.getParentIdentifier(), versionStorageData.getACL());
        }
        InternalQName vhName = new InternalQName(null, this.versionHistoryIdentifier);
        TransientNodeData versionHistory = TransientNodeData.createNodeData(versionStorageData, vhName, Constants.NT_VERSIONHISTORY, this.versionHistoryIdentifier);
        TransientPropertyData vhPrimaryType = TransientPropertyData.createPropertyData((NodeData)versionHistory, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(versionHistory.getPrimaryTypeName()));
        TransientPropertyData vhUuid = TransientPropertyData.createPropertyData((NodeData)versionHistory, Constants.JCR_UUID, 1, false, new TransientValueData(this.versionHistoryIdentifier));
        TransientPropertyData vhVersionableUuid = TransientPropertyData.createPropertyData((NodeData)versionHistory, Constants.JCR_VERSIONABLEUUID, 1, false, new TransientValueData(versionable.getIdentifier()));
        TransientNodeData vhVersionLabels = TransientNodeData.createNodeData(versionHistory, Constants.JCR_VERSIONLABELS, Constants.NT_VERSIONLABELS);
        TransientPropertyData vlPrimaryType = TransientPropertyData.createPropertyData((NodeData)vhVersionLabels, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(vhVersionLabels.getPrimaryTypeName()));
        TransientNodeData rootVersionData = TransientNodeData.createNodeData((NodeData)versionHistory, Constants.JCR_ROOTVERSION, Constants.NT_VERSION, this.baseVersionIdentifier);
        TransientPropertyData rvPrimaryType = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(rootVersionData.getPrimaryTypeName()));
        TransientPropertyData rvUuid = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_UUID, 1, false, new TransientValueData(this.baseVersionIdentifier));
        TransientPropertyData rvMixinTypes = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_MIXINTYPES, 7, true, new TransientValueData(Constants.MIX_REFERENCEABLE));
        TransientPropertyData rvCreated = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_CREATED, 5, false, new TransientValueData(Calendar.getInstance()));
        TransientPropertyData vh = TransientPropertyData.createPropertyData(versionable, Constants.JCR_VERSIONHISTORY, 9, false, new TransientValueData(new Identifier(this.versionHistoryIdentifier)));
        TransientPropertyData bv = TransientPropertyData.createPropertyData(versionable, Constants.JCR_BASEVERSION, 9, false, new TransientValueData(new Identifier(this.baseVersionIdentifier)));
        TransientPropertyData pd = TransientPropertyData.createPropertyData(versionable, Constants.JCR_PREDECESSORS, 9, true, new TransientValueData(new Identifier(this.baseVersionIdentifier)));
        QPath vpath = versionable.getQPath();
        changes.add(new ItemState(versionHistory, 1, true, vpath, true));
        changes.add(new ItemState(vhPrimaryType, 1, true, vpath, true));
        changes.add(new ItemState(vhUuid, 1, true, vpath, true));
        changes.add(new ItemState(vhVersionableUuid, 1, true, vpath, true));
        changes.add(new ItemState(vhVersionLabels, 1, true, vpath, true));
        changes.add(new ItemState(vlPrimaryType, 1, true, vpath, true));
        changes.add(new ItemState(rootVersionData, 1, true, vpath, true));
        changes.add(new ItemState(rvPrimaryType, 1, true, vpath, true));
        changes.add(new ItemState(rvMixinTypes, 1, true, vpath, true));
        changes.add(new ItemState(rvUuid, 1, true, vpath, true));
        changes.add(new ItemState(rvCreated, 1, true, vpath, true));
        changes.add(ItemState.createAddedState(vh));
        changes.add(ItemState.createAddedState(bv));
        changes.add(ItemState.createAddedState(pd));
        return versionHistory;
    }
}

