/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.xml.ItemDataKeeperAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionHistoryImporter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.VersionHistoryImporter");
    private final NodeImpl versionableNode;
    private final InputStream versionHistoryStream;
    private final SessionImpl userSession;
    private final NodeTypeDataManager nodeTypeDataManager;
    private final ItemDataKeeperAdapter dataKeeper;
    private final String baseVersionUuid;
    private final String[] predecessors;
    private final String versionHistory;
    private String uuid;
    private String path;

    public VersionHistoryImporter(NodeImpl versionableNode, InputStream versionHistoryStream, String baseVersionUuid, String[] predecessors, String versionHistory) throws RepositoryException {
        this.versionableNode = versionableNode;
        this.versionHistoryStream = versionHistoryStream;
        this.baseVersionUuid = baseVersionUuid;
        this.predecessors = predecessors;
        this.versionHistory = versionHistory;
        this.userSession = versionableNode.getSession();
        this.nodeTypeDataManager = this.userSession.getWorkspace().getNodeTypesHolder();
        this.dataKeeper = new ItemDataKeeperAdapter(this.userSession.getTransientNodesManager());
    }

    public void doImport() throws RepositoryException, IOException {
        try {
            List versionUuids;
            this.uuid = this.versionableNode.getUUID();
            this.path = this.versionableNode.getVersionHistory().getParent().getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Started: Import version history for node with path=" + this.path + " and UUID=" + this.uuid));
            }
            NodeData versionable = (NodeData)this.versionableNode.getData();
            TransientPropertyData vh = TransientPropertyData.createPropertyData(versionable, Constants.JCR_VERSIONHISTORY, 9, false, new TransientValueData(new Identifier(this.versionHistory)));
            TransientPropertyData bv = TransientPropertyData.createPropertyData(versionable, Constants.JCR_BASEVERSION, 9, false, new TransientValueData(new Identifier(this.baseVersionUuid)));
            ArrayList<ValueData> values = new ArrayList<ValueData>();
            for (int i = 0; i < this.predecessors.length; ++i) {
                values.add(new TransientValueData(new Identifier(this.predecessors[i])));
            }
            TransientPropertyData pd = TransientPropertyData.createPropertyData(versionable, Constants.JCR_PREDECESSORS, 9, true, values);
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
            RemoveVisitor rv = new RemoveVisitor(this);
            rv.visit((NodeData)((NodeImpl)this.versionableNode.getVersionHistory()).getData());
            changesLog.addAll(rv.getRemovedStates());
            changesLog.add(ItemState.createAddedState(vh));
            changesLog.add(ItemState.createAddedState(bv));
            changesLog.add(ItemState.createAddedState(pd));
            PlainChangesLogImpl changesLogDelete = new PlainChangesLogImpl();
            changesLogDelete.add(ItemState.createDeletedState(((PropertyImpl)this.versionableNode.getProperty("jcr:versionHistory")).getData()));
            changesLogDelete.add(ItemState.createDeletedState(((PropertyImpl)this.versionableNode.getProperty("jcr:baseVersion")).getData()));
            changesLogDelete.add(ItemState.createDeletedState(((PropertyImpl)this.versionableNode.getProperty("jcr:predecessors")).getData()));
            this.dataKeeper.save(changesLogDelete);
            this.dataKeeper.save(changesLog);
            this.userSession.save();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("respectPropertyDefinitionsConstraints", true);
            this.userSession.getWorkspace().importXML(this.path, this.versionHistoryStream, 0, context);
            this.userSession.save();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Completed: Import version history for node with path=" + this.path + " and UUID=" + this.uuid));
            }
            if ((versionUuids = (List)context.get("importedSubversions")) != null && !versionUuids.isEmpty()) {
                this.updateVersionedChildNodes(versionUuids);
            }
        }
        catch (RepositoryException exception) {
            LOG.error((Object)("Failed: Import version history for node with path=" + this.path + " and UUID=" + this.uuid), (Throwable)exception);
            throw new RepositoryException((Throwable)exception);
        }
        catch (IOException exception) {
            LOG.error((Object)("Failed: Import version history for node with path=" + this.path + " and UUID=" + this.uuid), (Throwable)exception);
            IOException newException = new IOException();
            newException.initCause(exception);
            throw newException;
        }
    }

    private void updateVersionedChildNodes(List<String> versionUuids) throws RepositoryException, IOException {
        SessionDataManager dataManager = this.userSession.getTransientNodesManager();
        NodeData versionStorage = (NodeData)dataManager.getItemData("00exo0jcr0version0storage0uuid00");
        for (String versionUuid : versionUuids) {
            NodeData nodeData;
            NodeData versionHistoryData = (NodeData)dataManager.getItemData(versionStorage, new QPathEntry("", versionUuid, 1), ItemType.NODE);
            PropertyData versionableUuidProp = (PropertyData)dataManager.getItemData(versionHistoryData, new QPathEntry(Constants.JCR_VERSIONABLEUUID, 1), ItemType.PROPERTY);
            String versionableUuid = ValueDataUtil.getString(versionableUuidProp.getValues().get(0));
            NodeData versionedChild = (NodeData)dataManager.getItemData(versionableUuid);
            if (versionedChild == null || !versionedChild.getQPath().isDescendantOf(this.versionableNode.getData().getQPath())) continue;
            String latestVersionUuid = null;
            int versionNumber = 1;
            while ((nodeData = (NodeData)dataManager.getItemData(versionHistoryData, new QPathEntry("", Integer.toString(versionNumber), 1), ItemType.NODE)) != null) {
                latestVersionUuid = nodeData.getIdentifier();
                ++versionNumber;
            }
            if (latestVersionUuid == null) {
                NodeData rootVersion = (NodeData)dataManager.getItemData(versionHistoryData, new QPathEntry(Constants.JCR_ROOTVERSION, 1), ItemType.NODE);
                latestVersionUuid = rootVersion.getIdentifier();
            }
            PropertyData propVersionHistory = (PropertyData)dataManager.getItemData(versionedChild, new QPathEntry(Constants.JCR_VERSIONHISTORY, 1), ItemType.PROPERTY);
            String prevVerHistoryId = ValueDataUtil.getString(propVersionHistory.getValues().get(0));
            PropertyData propBaseVersion = (PropertyData)dataManager.getItemData(versionedChild, new QPathEntry(Constants.JCR_BASEVERSION, 1), ItemType.PROPERTY);
            PropertyData propPredecessors = (PropertyData)dataManager.getItemData(versionedChild, new QPathEntry(Constants.JCR_PREDECESSORS, 1), ItemType.PROPERTY);
            TransientPropertyData newVersionHistoryProp = TransientPropertyData.createPropertyData(versionedChild, Constants.JCR_VERSIONHISTORY, 9, false, new TransientValueData(new Identifier(versionUuid)));
            TransientPropertyData newBaseVersionProp = TransientPropertyData.createPropertyData(versionedChild, Constants.JCR_BASEVERSION, 9, false, new TransientValueData(new Identifier(latestVersionUuid)));
            ArrayList<ValueData> predecessorValues = new ArrayList<ValueData>();
            predecessorValues.add(new TransientValueData(new Identifier(latestVersionUuid)));
            TransientPropertyData newPredecessorsProp = TransientPropertyData.createPropertyData(versionedChild, Constants.JCR_PREDECESSORS, 9, true, predecessorValues);
            NodeData prevVersionHistory = (NodeData)dataManager.getItemData(prevVerHistoryId);
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
            if (!prevVerHistoryId.equals(versionUuid)) {
                RemoveVisitor rv = new RemoveVisitor(this);
                rv.visit(prevVersionHistory);
                changesLog.addAll(rv.getRemovedStates());
            }
            changesLog.add(ItemState.createAddedState(newVersionHistoryProp));
            changesLog.add(ItemState.createAddedState(newBaseVersionProp));
            changesLog.add(ItemState.createAddedState(newPredecessorsProp));
            PlainChangesLogImpl changesLogDelete = new PlainChangesLogImpl();
            changesLogDelete.add(ItemState.createDeletedState(propVersionHistory));
            changesLogDelete.add(ItemState.createDeletedState(propBaseVersion));
            changesLogDelete.add(ItemState.createDeletedState(propPredecessors));
            this.dataKeeper.save(changesLogDelete);
            this.dataKeeper.save(changesLog);
            this.userSession.save();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Completed: Import version history for node with path=" + versionedChild.getQPath().getAsString() + " and UUID=" + versionedChild.getIdentifier()));
        }
    }

    protected class RemoveVisitor
    extends ItemDataRemoveVisitor {
        RemoveVisitor(VersionHistoryImporter this$0) throws RepositoryException {
            super(this$0.userSession.getTransientNodesManager(), null, this$0.nodeTypeDataManager, this$0.userSession.getAccessManager(), this$0.userSession.getUserState());
        }

        @Override
        protected void validateReferential(NodeData node) throws RepositoryException {
        }
    }
}

