/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.File;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.opengis.util.InternationalString;

public final class TreeTables
extends Static {
    private TreeTables() {
    }

    public static TreeTable.Node nodeForPath(TreeTable.Node node, TableColumn<? super String> tableColumn, Path path) {
        Path path2;
        Path path3 = path.getParent();
        if (path3 != null) {
            node = TreeTables.nodeForPath(node, tableColumn, path3);
        }
        if ((path2 = path.getFileName()) == null) {
            path2 = path.getRoot();
        }
        String string = path2.toString();
        for (TreeTable.Node node2 : node.getChildren()) {
            if (!string.equals(node2.getValue(tableColumn))) continue;
            return node2;
        }
        node = node.newChild();
        node.setValue(tableColumn, string);
        return node;
    }

    public static TreeTable.Node nodeForPath(TreeTable.Node node, TableColumn<? super String> tableColumn, File file) {
        String string;
        File file2 = file.getParentFile();
        if (file2 != null) {
            node = TreeTables.nodeForPath(node, tableColumn, file2);
        }
        if ((string = file.getName()).isEmpty() && file2 == null) {
            string = File.separator;
        }
        for (TreeTable.Node node2 : node.getChildren()) {
            if (!string.equals(node2.getValue(tableColumn))) continue;
            return node2;
        }
        node = node.newChild();
        node.setValue(tableColumn, string);
        return node;
    }

    public static int replaceCharSequences(TreeTable treeTable, Locale locale) {
        ArgumentChecks.ensureNonNull("table", treeTable);
        List<TableColumn<?>> list = treeTable.getColumns();
        TableColumn[] tableColumnArray = new TableColumn[list.size()];
        int n = 0;
        for (TableColumn<?> tableColumn : list) {
            if (!tableColumn.getElementType().isAssignableFrom(String.class)) continue;
            tableColumnArray[n++] = tableColumn;
        }
        tableColumnArray = ArraysExt.resize(tableColumnArray, n);
        return TreeTables.replaceCharSequences(treeTable.getRoot(), tableColumnArray, locale, new HashMap<String, String>());
    }

    private static int replaceCharSequences(TreeTable.Node node, TableColumn<? super String>[] tableColumnArray, Locale locale, Map<String, String> map) {
        int n = 0;
        for (TreeTable.Node node2 : node.getChildren()) {
            n += TreeTables.replaceCharSequences(node2, tableColumnArray, locale, map);
        }
        for (TableColumn<? super String> tableColumn : tableColumnArray) {
            String string = node.getValue(tableColumn);
            if (string == null) continue;
            String string2 = string instanceof InternationalString ? ((InternationalString)string).toString(locale) : string.toString();
            String string3 = map.put(string2, string2);
            if (string3 != null) {
                map.put(string3, string3);
                string2 = string3;
            }
            if (string2 == string) continue;
            node.setValue(tableColumn, string2);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(TreeTable treeTable) {
        ArgumentChecks.ensureNonNull("table", treeTable);
        TreeTableFormat treeTableFormat = TreeTableFormat.INSTANCE;
        synchronized (treeTableFormat) {
            return TreeTableFormat.INSTANCE.format(treeTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeTable parse(String string, TableColumn<?> tableColumn, TableColumn<?> ... tableColumnArray) throws ParseException {
        TreeTableFormat treeTableFormat;
        ArgumentChecks.ensureNonNull("tree", string);
        ArgumentChecks.ensureNonNull("labelColumn", tableColumn);
        TableColumn<?>[] tableColumnArray2 = null;
        if (tableColumnArray.length != 0 || tableColumn != TableColumn.NAME) {
            tableColumnArray2 = ArraysExt.insert(tableColumnArray, 0, 1);
            tableColumnArray2[0] = tableColumn;
        }
        TreeTableFormat treeTableFormat2 = treeTableFormat = TreeTableFormat.INSTANCE;
        synchronized (treeTableFormat2) {
            TreeTable treeTable;
            try {
                treeTableFormat.setColumns(tableColumnArray2);
                treeTable = (TreeTable)treeTableFormat.parseObject(string);
            }
            catch (Throwable throwable) {
                treeTableFormat.setColumns(null);
                throw throwable;
            }
            treeTableFormat.setColumns(null);
            return treeTable;
        }
    }
}

