/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.TransformedCollection;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.Utils;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.jcr.impl.checker.InspectionReport;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryHandler;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.ErrorLog;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.RSyncConfiguration;
import org.exoplatform.services.jcr.impl.core.query.SearchIndexConfigurationHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractRecoveryFilter;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheck;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheckError;
import org.exoplatform.services.jcr.impl.core.query.lucene.DefaultHTMLExcerpt;
import org.exoplatform.services.jcr.impl.core.query.lucene.DefaultIndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberRecoveryFilter;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.FileBasedNamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.FilterMultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineIOException;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfigurationEntityResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfigurationImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.NSRegistryBasedNamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIndexer;
import org.exoplatform.services.jcr.impl.core.query.lucene.PerQueryCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldComparatorSource;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldInsensitiveComparatorSource;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingletonTokenStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellChecker;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.VolatileIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.FSDirectoryManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.statistics.JCRStatisticsManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SearchIndex
extends AbstractQueryHandler
implements IndexerIoModeListener,
Suspendable {
    private static final DefaultQueryNodeFactory DEFAULT_QUERY_NODE_FACTORY = new DefaultQueryNodeFactory();
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.SearchIndex");
    private static final String NS_MAPPING_FILE = "ns_mappings.properties";
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_EXTRACTOR_BACK_LOG = Integer.MAX_VALUE;
    public static final long DEFAULT_EXTRACTOR_TIMEOUT = 100L;
    public static final long DEFAULT_MAX_VOLATILE_INDEX_SIZE = 0x100000L;
    public static final int DEFAULT_MAX_VOLATILE_TIME = -1;
    public static final int DEFAULT_TERM_INFOS_INDEX_DIVISOR = 1;
    public static final int DEFAULT_REINDEXING_PAGE_SIZE = 100;
    public static final boolean DEFAULT_RDBMS_REINDEXING = true;
    public static final boolean DEFAULT_ASYNC_REINDEXING = false;
    private static final Integer DEFAULT_INDEXING_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_INDEXING_LOAD_BATCHING_THRESHOLD = -1;
    private static final long DEFAULT_INDEXING_LOAD_BATCHING_THRESHOLD_TTL = 300000L;
    public static final String INDEX_RECOVERY_MODE_FROM_INDEXING = "from-indexing";
    public static final String INDEX_RECOVERY_MODE_FROM_COORDINATOR = "from-coordinator";
    public static final String INDEX_RECOVERY_RSYNC_WITH_DELETE_STRATEGY = "rsync-with-delete";
    public static final String INDEX_RECOVERY_RSYNC_STRATEGY = "rsync";
    public static final String INDEX_RECOVERY_DEFAULT_STRATEGY = "copy";
    private static final String ERROR_LOG = "error.log";
    private IndexRegister indexRegister;
    private JcrStandartAnalyzer analyzer;
    private NamespaceMappings nsMappings;
    private String path;
    private int minMergeDocs = 100;
    private long maxVolatileIndexSize = 0x100000L;
    private int maxVolatileTime = -1;
    private int volatileIdleTime = 3;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private int extractorPoolSize = 2 * Runtime.getRuntime().availableProcessors();
    private int extractorBackLog = Integer.MAX_VALUE;
    private long extractorTimeout = 100L;
    private int bufferSize = 10;
    private boolean useCompoundFile = true;
    private boolean documentOrder = true;
    private boolean forceConsistencyCheck = false;
    private boolean consistencyCheckEnabled = false;
    private boolean autoRepair = true;
    private int cacheSize = 1000;
    private int resultFetchSize = Integer.MAX_VALUE;
    private boolean supportHighlighting = false;
    private Class<? extends ExcerptProvider> excerptProviderClass = DefaultHTMLExcerpt.class;
    private String indexingConfigPath;
    private Element indexingConfiguration;
    private IndexingConfiguration indexingConfig;
    private LocationFactory npResolver;
    private Class<? extends IndexingConfiguration> indexingConfigurationClass = IndexingConfigurationImpl.class;
    private Class<? extends SynonymProvider> synonymProviderClass;
    private SynonymProvider synProvider;
    private String synonymProviderConfigPath;
    private InputStream synonymProviderConfigFs;
    private IndexFormatVersion indexFormatVersion;
    private Class<? extends SpellChecker> spellCheckerClass;
    private SpellChecker spellChecker;
    private boolean spellCheckerMorePopular = true;
    private float spellCheckerMinDistance = 0.55f;
    private Similarity similarity = Similarity.getDefault();
    private String directoryManagerClass = FSDirectoryManager.class.getName();
    private DirectoryManager directoryManager;
    private int termInfosIndexDivisor = 1;
    private FieldComparatorSource scs;
    private FieldComparatorSource sics;
    private boolean initializeHierarchyCache = true;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean allowQuery = new AtomicBoolean(true);
    private DocumentReaderService extractor;
    public static final int DEFAULT_ERRORLOG_FILE_SIZE = 50;
    private int errorLogfileSize = 50;
    private ErrorLog errorLog;
    private final String wsId;
    private final ConfigurationManager cfm;
    private int reindexingPageSize = 100;
    private boolean rdbmsReindexing = true;
    private String indexRecoveryMode = "from-coordinator";
    private RSyncConfiguration rsyncConfiguration;
    private String indexRecoveryStrategy = "copy";
    private boolean asyncReindexing = false;
    protected final AtomicReference<CountDownLatch> latcher = new AtomicReference();
    protected final AtomicBoolean isSuspended = new AtomicBoolean(false);
    protected AtomicInteger workingThreads = new AtomicInteger();
    protected final Set<String> recoveryFilterClasses;
    protected List<AbstractRecoveryFilter> recoveryFilters = null;
    protected Map<String, String> optionalParameters = new HashMap<String, String>();
    protected Integer indexingThreadPoolSize = DEFAULT_INDEXING_THREAD_POOL_SIZE;
    private boolean indexingLoadBatchingThresholdDynamic;
    private long indexingLoadBatchingThresholdTTL;
    private int indexingLoadBatchingThresholdProperty = -1;
    private int indexingLoadBatchingThresholdNode = -1;
    private boolean indexingLoadPropertyByName;
    private static volatile Timer TIMER;
    private TimerTask updateLoadBatchingThresholdTask;
    private static final Comparator<Fieldable> FIELDS_COMPARATOR_STORED;

    public SearchIndex(String wsId, QueryHandlerEntry queryHandlerConfig, ConfigurationManager cfm) throws IOException, RepositoryConfigurationException {
        this.wsId = wsId;
        this.analyzer = new JcrStandartAnalyzer();
        this.cfm = cfm;
        this.recoveryFilterClasses = new LinkedHashSet<String>();
        SearchIndexConfigurationHelper searchIndexConfigurationHelper = new SearchIndexConfigurationHelper(this);
        searchIndexConfigurationHelper.init(queryHandlerConfig);
    }

    public SearchIndex(QueryHandlerEntry queryHandlerConfig, ConfigurationManager cfm) throws IOException, RepositoryConfigurationException {
        this(null, queryHandlerConfig, cfm);
    }

    public SearchIndex() {
        this.analyzer = new JcrStandartAnalyzer();
        this.cfm = null;
        this.wsId = null;
        this.recoveryFilterClasses = new LinkedHashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void doInit() throws IOException, RepositoryException {
        QueryHandlerContext context = this.getContext();
        this.setPath(context.getIndexDirectory());
        if (this.path == null) {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        if (this.path == null) throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        File indexDirectory = new File(this.path);
        if (!indexDirectory.exists() && !indexDirectory.mkdirs()) {
            throw new RepositoryException("fail to create index dir " + this.path);
        }
        log.info((Object)("Index created: " + this.path));
        this.extractor = context.getExtractor();
        this.synProvider = this.createSynonymProvider();
        this.directoryManager = this.createDirectoryManager();
        if (context.getParentHandler() instanceof SearchIndex) {
            SearchIndex sysIndex = (SearchIndex)context.getParentHandler();
            this.nsMappings = sysIndex.getNamespaceMappings();
        } else {
            File mapFile = new File(indexDirectory, NS_MAPPING_FILE);
            this.nsMappings = mapFile.exists() ? new FileBasedNamespaceMappings(mapFile) : new NSRegistryBasedNamespaceMappings(context.getNamespaceRegistry());
        }
        this.scs = new SharedFieldComparatorSource(FieldNames.PROPERTIES, context.getItemStateManager(), this.nsMappings);
        this.sics = new SharedFieldInsensitiveComparatorSource(FieldNames.PROPERTIES, context.getItemStateManager(), this.nsMappings);
        this.npResolver = new LocationFactory(this.nsMappings);
        this.indexingConfig = this.createIndexingConfiguration(this.nsMappings);
        this.analyzer.setIndexingConfig(this.indexingConfig);
        MultiIndex index = new MultiIndex(this, context.getIndexingTree(), this.modeHandler, this.getIndexInfos(), this.getIndexUpdateMonitor());
        this.indexRegister = new IndexRegister(this, index);
        if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            final boolean doReindexing = index.numDocs() == 0 && context.isCreateInitialIndex();
            final boolean doForceReindexing = context.isRecoveryFilterUsed() && this.isIndexRecoveryRequired();
            final boolean doCheck = this.consistencyCheckEnabled && (index.getRedoLogApplied() || this.forceConsistencyCheck);
            final ItemDataConsumer itemStateManager = context.getItemStateManager();
            if (this.isAsyncReindexing() && doReindexing) {
                log.info((Object)"Launching reindexing in asynchronous mode.");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SearchIndex.this.reindex(doReindexing, doForceReindexing, doCheck, itemStateManager);
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while reindexing the workspace. Please fix the problem, delete index and restart server.", (Throwable)e);
                        }
                    }
                }, "Reindexing-" + context.getRepositoryName() + "-" + context.getContainer().getWorkspaceName()).start();
            } else {
                this.reindex(doReindexing, doForceReindexing, doCheck, itemStateManager);
            }
        }
        this.spellChecker = this.createSpellChecker();
        log.info("Index initialized: {} Version: {}", new Object[]{this.path, index.getIndexFormatVersion()});
        if (!index.getIndexFormatVersion().equals(this.getIndexFormatVersion())) {
            log.warn("Using Version {} for reading. Please re-index version storage for optimal performance.", new Object[]{this.getIndexFormatVersion().getVersion()});
        }
        this.errorLog = this.doInitErrorLog(this.path);
        if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            this.recoverErrorLog(this.errorLog);
        }
        this.modeHandler.addIndexerIoModeListener(this);
        if (this.indexingLoadBatchingThresholdDynamic && (this.indexingLoadBatchingThresholdProperty > -1 || this.indexingLoadBatchingThresholdNode > -1)) {
            if (JDBCWorkspaceDataContainer.STATISTICS_ENABLED) {
                if (this.indexingLoadBatchingThresholdTTL <= 0L) {
                    this.indexingLoadBatchingThresholdTTL = 300000L;
                }
                log.debug((Object)"The statistics have been enabled so the load batching thresholds will be modified dynamically");
                if (TIMER == null) {
                    Class<SearchIndex> clazz = SearchIndex.class;
                    // MONITORENTER : org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex.class
                    if (TIMER == null) {
                        TIMER = new Timer("SearchIndex Update Load Batching Thresholds Timer", true);
                    }
                    // MONITOREXIT : clazz
                }
                this.scheduleUpdateLoadBatchingThresholdTask();
            } else {
                log.debug((Object)"The statistics have not been enabled so the load batching thresholds won't be modified dynamically");
            }
        }
        this.indexingLoadPropertyByName = this.indexingLoadBatchingThresholdProperty > -1;
    }

    private void scheduleUpdateLoadBatchingThresholdTask() {
        this.updateLoadBatchingThresholdTask = new TimerTask(){

            @Override
            public void run() {
                SearchIndex.this.checkLoadBatchingThresholds();
            }
        };
        TIMER.schedule(this.updateLoadBatchingThresholdTask, 0L, this.indexingLoadBatchingThresholdTTL);
    }

    private void unscheduleUpdateLoadBatchingThresholdTask() {
        if (this.updateLoadBatchingThresholdTask != null) {
            this.updateLoadBatchingThresholdTask.cancel();
            TIMER.purge();
        }
    }

    private void checkLoadBatchingThresholds() {
        float getByIdAvg = JCRStatisticsManager.getAvg("JDBCStorageConnection", "getItemDataById");
        if (getByIdAvg <= 0.0f) {
            log.debug("Don't have any statistics about '{}' so we cannot go any further for now", new Object[]{"getItemDataById"});
            return;
        }
        float getByNameAvg = JCRStatisticsManager.getAvg("JDBCStorageConnection", "getItemDataByNodeDataNQPathEntry");
        if (getByNameAvg <= 0.0f) {
            log.debug("Don't have any statistics about '{}' so we cannot go any further for now", new Object[]{"getItemDataByNodeDataNQPathEntry"});
            return;
        }
        log.debug("getByIdAvg = {} and getByNameAvg = {}", new Object[]{Float.valueOf(getByIdAvg), Float.valueOf(getByNameAvg)});
        this.indexingLoadPropertyByName = getByIdAvg >= getByNameAvg;
        log.debug("The new value of indexingLoadPropertyByName is {}", new Object[]{this.indexingLoadPropertyByName});
        if (this.indexingLoadBatchingThresholdProperty > -1) {
            float getPropertiesByNameAvg = JCRStatisticsManager.getAvg("JDBCStorageConnection", "getChildPropertiesDataPattern");
            if (getPropertiesByNameAvg <= 0.0f) {
                log.debug("Don't have any statistics about '{}' so we cannot go any further for this threshold now", new Object[]{"getChildPropertiesDataPattern"});
            } else {
                log.debug("getPropertiesByNameAvg = {}", new Object[]{Float.valueOf(getPropertiesByNameAvg)});
                this.indexingLoadBatchingThresholdProperty = Math.round(getPropertiesByNameAvg / Math.min(getByIdAvg, getByNameAvg)) + 1;
                log.debug("The new value of indexingLoadBatchingThresholdProperty is {}", new Object[]{this.indexingLoadBatchingThresholdProperty});
            }
        }
        if (this.indexingLoadBatchingThresholdNode > -1) {
            float getAllPropertiesAvg = JCRStatisticsManager.getAvg("JDBCStorageConnection", "getChildPropertiesData");
            if (getAllPropertiesAvg <= 0.0f) {
                log.debug("Don't have any statistics about '{}' so we cannot go any further for this threshold now", new Object[]{"getChildPropertiesData"});
                return;
            }
            float listAllPropertiesAvg = JCRStatisticsManager.getAvg("JDBCStorageConnection", "listChildPropertiesData");
            if (listAllPropertiesAvg <= 0.0f) {
                log.debug("Don't have any statistics about '{}' so we cannot go any further for this threshold now", new Object[]{"listChildPropertiesData"});
                return;
            }
            log.debug("getAllPropertiesAvg = {} and listAllPropertiesAvg = {}", new Object[]{Float.valueOf(getAllPropertiesAvg), Float.valueOf(listAllPropertiesAvg)});
            this.indexingLoadBatchingThresholdNode = Math.round(getAllPropertiesAvg / (listAllPropertiesAvg + 4.0f * Math.min(getByIdAvg, getByNameAvg))) + 1;
            log.debug("The new value of indexingLoadBatchingThresholdNode is {}", new Object[]{this.indexingLoadBatchingThresholdNode});
        }
    }

    public String getWsId() {
        return this.wsId;
    }

    public void addRecoveryFilterClass(String recoveryFilterClassName) {
        this.recoveryFilterClasses.add(recoveryFilterClassName);
    }

    public void addOptionalParameter(String key, String value) {
        this.optionalParameters.put(key, value);
    }

    public Map<String, String> getOptionalParameters() {
        return Collections.unmodifiableMap(this.optionalParameters);
    }

    private boolean isIndexRecoveryRequired() throws RepositoryException {
        if (this.recoveryFilters == null) {
            this.recoveryFilters = new ArrayList<AbstractRecoveryFilter>();
            log.info((Object)"Initializing RecoveryFilters.");
            if (this.recoveryFilterClasses.isEmpty()) {
                this.recoveryFilterClasses.add(DocNumberRecoveryFilter.class.getName());
            }
            for (String recoveryFilterClassName : this.recoveryFilterClasses) {
                AbstractRecoveryFilter filter = null;
                try {
                    Class filterClass = ClassLoading.forName((String)recoveryFilterClassName, (Object)this);
                    Constructor constuctor = filterClass.getConstructor(SearchIndex.class);
                    filter = (AbstractRecoveryFilter)constuctor.newInstance(this);
                    this.recoveryFilters.add(filter);
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (SecurityException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (AbstractRecoveryFilter filter : this.recoveryFilters) {
            if (!filter.accept()) continue;
            return true;
        }
        return false;
    }

    private void reindex(boolean doReindexing, boolean doForceReindexing, boolean doCheck, ItemDataConsumer itemStateManager) throws IOException {
        if (doReindexing || doForceReindexing) {
            this.indexRegister.getDefaultIndex().createInitialIndex(itemStateManager, doForceReindexing);
        }
        if (doCheck) {
            log.info((Object)"Running consistency check...");
            try {
                ConsistencyCheck check = ConsistencyCheck.run(this.indexRegister.getDefaultIndex(), itemStateManager);
                if (this.autoRepair) {
                    check.repair(true);
                } else {
                    List<ConsistencyCheckError> errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info((Object)"No errors detected.");
                    }
                    for (ConsistencyCheckError err : errors) {
                        log.info((Object)err.toString());
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to run consistency check on index: " + String.valueOf(e)));
            }
        }
    }

    void ensureFlushed() throws IOException {
        if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            this.indexRegister.getDefaultIndex().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIndex(ItemDataConsumer itemStateManager, boolean isSystem, final InspectionReport report) throws RepositoryException, IOException {
        this.ensureFlushed();
        if (isSystem && this.getContext().getParentHandler() != null) {
            ((SearchIndex)this.getContext().getParentHandler()).ensureFlushed();
        }
        IndexReader indexReader = this.getIndexReader(isSystem);
        try {
            ItemData root = itemStateManager.getItemData("00exo0jcr0root0uuid0000000000000");
            class ItemDataIndexConsistencyVisitor
            extends ItemDataTraversingVisitor {
                private final IndexReader indexReader;
                private final Set<String> indexedNodes;

                public ItemDataIndexConsistencyVisitor(ItemDataConsumer dataManager, IndexReader indexReader) {
                    super(dataManager);
                    this.indexedNodes = new HashSet<String>();
                    this.indexReader = indexReader;
                }

                @Override
                protected void entering(PropertyData property, int level) throws RepositoryException {
                }

                @Override
                protected void entering(NodeData node, int level) throws RepositoryException {
                    try {
                        String uuid = node.getIdentifier();
                        TermDocs docs = this.indexReader.termDocs(new Term(FieldNames.UUID, uuid));
                        if (docs.next()) {
                            this.indexedNodes.add(uuid);
                            docs.doc();
                            if (docs.next()) {
                                report.logComment("Multiple entires.");
                                report.logBrokenObjectAndSetInconsistency("ID=" + uuid);
                            }
                        } else {
                            report.logComment("Not indexed.");
                            report.logBrokenObjectAndSetInconsistency("ID=" + uuid);
                        }
                    }
                    catch (IOException e) {
                        throw new RepositoryException(e.getMessage(), (Throwable)e);
                    }
                }

                @Override
                protected void leaving(PropertyData property, int level) throws RepositoryException {
                }

                @Override
                protected void leaving(NodeData node, int level) throws RepositoryException {
                }

                @Override
                protected void visitChildProperties(NodeData node) throws RepositoryException {
                }

                public Set<String> getIndexedNodes() {
                    return this.indexedNodes;
                }
            }
            ItemDataIndexConsistencyVisitor visitor = new ItemDataIndexConsistencyVisitor(itemStateManager, indexReader);
            root.accept(visitor);
            Set<String> documentUUIDs = visitor.getIndexedNodes();
            for (int i = 0; i < indexReader.maxDoc(); ++i) {
                int currentIndex;
                Document d;
                String uuid;
                if (indexReader.isDeleted(i) || documentUUIDs.contains(uuid = (d = indexReader.document(currentIndex = i, FieldSelectors.UUID)).get(FieldNames.UUID))) continue;
                report.logComment("Document corresponds to removed node.");
                report.logBrokenObjectAndSetInconsistency("ID=" + uuid);
            }
        }
        finally {
            Util.closeOrRelease(indexReader);
        }
    }

    public int getErrorLogfileSize() {
        return this.errorLogfileSize;
    }

    public void setErrorLogfileSize(int errorLogfileSize) {
        this.errorLogfileSize = errorLogfileSize;
    }

    @Override
    public void addNode(NodeData node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    @Override
    public void deleteNode(String id) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    @Override
    public void updateNodes(Iterator<String> remove, Iterator<NodeData> add) throws RepositoryException, IOException {
        this.checkOpen();
        this.apply(this.getChanges(remove, add));
    }

    @Override
    public void apply(ChangesHolder changes) throws RepositoryException, IOException {
        this.checkOpen();
        if (this.indexRegister.getDefaultIndex() != null) {
            this.indexRegister.getDefaultIndex().update(changes.getRemove(), changes.getAdd());
        }
        for (MultiIndex index : this.indexRegister.getIndexList()) {
            try {
                index.update(changes.getRemove(), changes.getAdd());
            }
            catch (Exception e) {
                log.error((Object)("Error indexing changes " + String.valueOf(e)), (Throwable)e);
                try {
                    this.logErrorChanges(this.indexRegister.getErrorLogs(index), new HashSet<String>(changes.getRemove()), new HashSet<String>(changes.getAddIds()));
                }
                catch (IOException ioe) {
                    log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + String.valueOf(ioe)), (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public ChangesHolder getChanges(Iterator<String> remove, Iterator<NodeData> add) {
        final HashMap<String, NodeData> aggregateRoots = new HashMap<String, NodeData>();
        final HashSet<String> removedNodeIds = new HashSet<String>();
        final HashSet addedNodeIds = new HashSet();
        List docIdsToRemove = IteratorUtils.toList((Iterator)new TransformIterator(remove, new Transformer(){

            public Object transform(Object input) {
                String uuid = (String)input;
                removedNodeIds.add(uuid);
                return uuid;
            }
        }));
        final AtomicInteger totalAddedDoc = new AtomicInteger();
        List docsToAdd = IteratorUtils.toList((Iterator)new TransformIterator(add, new Transformer(){

            public Object transform(Object input) {
                NodeData state = (NodeData)input;
                if (state == null) {
                    return null;
                }
                boolean loadAllProperties = SearchIndex.this.indexingLoadBatchingThresholdNode > -1 && totalAddedDoc.incrementAndGet() > SearchIndex.this.indexingLoadBatchingThresholdNode;
                String uuid = state.getIdentifier();
                addedNodeIds.add(uuid);
                removedNodeIds.remove(uuid);
                Document doc = null;
                try {
                    doc = SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.indexRegister.getDefaultIndex().getIndexFormatVersion(), loadAllProperties);
                    SearchIndex.this.retrieveAggregateRoot(state, (Map<String, NodeData>)aggregateRoots);
                }
                catch (RepositoryException e) {
                    log.warn((Object)("Exception while creating document for node: " + state.getIdentifier() + ": " + e.toString()), (Throwable)e);
                }
                return doc;
            }
        }));
        aggregateRoots.keySet().removeAll(addedNodeIds);
        this.retrieveAggregateRoot(removedNodeIds, aggregateRoots);
        if (aggregateRoots.size() > 0) {
            Collection modified = TransformedCollection.decorate(new ArrayList(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    NodeData state = (NodeData)input;
                    boolean loadAllProperties = SearchIndex.this.indexingLoadBatchingThresholdNode > -1 && totalAddedDoc.incrementAndGet() > SearchIndex.this.indexingLoadBatchingThresholdNode;
                    try {
                        return SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.indexRegister.getDefaultIndex().getIndexFormatVersion(), loadAllProperties);
                    }
                    catch (RepositoryException e) {
                        log.warn((Object)("Exception while creating document for node: " + state.getIdentifier() + ": " + e.toString()));
                        return null;
                    }
                }
            });
            modified.addAll(aggregateRoots.values());
            docIdsToRemove.addAll(aggregateRoots.keySet());
            docsToAdd.addAll(modified);
        }
        if (docIdsToRemove.isEmpty() && docsToAdd.isEmpty()) {
            return null;
        }
        return new ChangesHolder(docIdsToRemove, docsToAdd);
    }

    @Override
    public ExecutableQuery createExecutableQuery(SessionImpl session, SessionDataManager itemMgr, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(session, itemMgr, this, this.getContext().getPropertyTypeRegistry(), statement, language, this.getQueryNodeFactory());
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    protected DefaultQueryNodeFactory getQueryNodeFactory() {
        return DEFAULT_QUERY_NODE_FACTORY;
    }

    @Override
    public void close() {
        this.closeAndKeepWaitingThreads(true);
        this.resumeWaitingThreads();
    }

    private void closeAndKeepWaitingThreads(boolean completeClose) {
        if (!this.closed.get()) {
            if (completeClose && this.recoveryFilters != null) {
                for (AbstractRecoveryFilter filter : this.recoveryFilters) {
                    filter.close();
                }
                this.recoveryFilters.clear();
                this.recoveryFilters = null;
            }
            if (this.synonymProviderConfigFs != null) {
                try {
                    this.synonymProviderConfigFs.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Exception while closing FileSystem", (Throwable)e);
                }
            }
            if (this.spellChecker != null) {
                this.spellChecker.close();
            }
            this.errorLog.close();
            this.indexRegister.getDefaultIndex().close();
            this.getContext().destroy();
            this.closed.set(true);
            log.info((Object)("Index closed: " + this.path));
            this.modeHandler.removeIndexerIoModeListener(this);
            if (this.indexInfos instanceof IndexerIoModeListener) {
                this.modeHandler.removeIndexerIoModeListener((IndexerIoModeListener)((Object)this.indexInfos));
            }
            if (this.indexUpdateMonitor instanceof IndexerIoModeListener) {
                this.modeHandler.removeIndexerIoModeListener((IndexerIoModeListener)((Object)this.indexUpdateMonitor));
            }
            this.unscheduleUpdateLoadBatchingThresholdTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiColumnQueryHits executeQuery(SessionImpl session, AbstractQueryImpl queryImpl, Query query, QPath[] orderProps, boolean[] orderSpecs, long resultFetchHint) throws IOException, RepositoryException {
        this.waitForResuming();
        this.checkOpen();
        this.workingThreads.incrementAndGet();
        try {
            FieldComparatorSource scs = queryImpl.isCaseInsensitiveOrder() ? this.sics : this.scs;
            Sort sort = new Sort(this.createSortFields(orderProps, orderSpecs, scs));
            final IndexReader reader = this.getIndexReader(queryImpl.needsSystemTree());
            JcrIndexSearcher searcher = new JcrIndexSearcher(session, reader, this.getContext().getItemStateManager());
            searcher.setSimilarity(this.getSimilarity());
            FilterMultiColumnQueryHits filterMultiColumnQueryHits = new FilterMultiColumnQueryHits(this, searcher.execute(query, sort, resultFetchHint, QueryImpl.DEFAULT_SELECTOR_NAME)){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        PerQueryCache.getInstance().dispose();
                        Util.closeOrRelease(reader);
                    }
                }
            };
            return filterMultiColumnQueryHits;
        }
        finally {
            this.workingThreads.decrementAndGet();
            if (this.isSuspended.get() && this.workingThreads.get() == 0) {
                AtomicInteger atomicInteger = this.workingThreads;
                synchronized (atomicInteger) {
                    this.workingThreads.notifyAll();
                }
            }
        }
    }

    public ExcerptProvider createExcerptProvider(Query query) throws IOException {
        ExcerptProvider ep;
        try {
            ep = this.excerptProviderClass.newInstance();
        }
        catch (Exception e) {
            throw Util.createIOException(e);
        }
        ep.init(query, this);
        return ep;
    }

    public Analyzer getTextAnalyzer() {
        return this.analyzer;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public IndexingConfiguration getIndexingConfig() {
        return this.indexingConfig;
    }

    public SynonymProvider getSynonymProvider() {
        if (this.synProvider != null) {
            return this.synProvider;
        }
        QueryHandler handler = this.getContext().getParentHandler();
        if (handler instanceof SearchIndex) {
            return ((SearchIndex)handler).getSynonymProvider();
        }
        return null;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.getIndexReader(true);
    }

    public IndexFormatVersion getIndexFormatVersion() {
        if (this.indexFormatVersion == null) {
            SearchIndex parent;
            this.indexFormatVersion = this.getContext().getParentHandler() instanceof SearchIndex ? ((parent = (SearchIndex)this.getContext().getParentHandler()).getIndexFormatVersion().getVersion() < this.indexRegister.getDefaultIndex().getIndexFormatVersion().getVersion() ? parent.getIndexFormatVersion() : this.indexRegister.getDefaultIndex().getIndexFormatVersion()) : this.indexRegister.getDefaultIndex().getIndexFormatVersion();
        }
        return this.indexFormatVersion;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    protected IndexReader getIndexReader(boolean includeSystemIndex) throws IOException {
        MultiReader reader;
        if (!this.indexRegister.getDefaultIndex().isOnline() && !this.allowQuery.get()) {
            throw new IndexOfflineIOException("Index is offline");
        }
        QueryHandler parentHandler = this.getContext().getParentHandler();
        CachingMultiIndexReader parentReader = null;
        if (parentHandler instanceof SearchIndex && includeSystemIndex) {
            parentReader = ((SearchIndex)parentHandler).indexRegister.getDefaultIndex().getIndexReader();
        }
        if (parentReader != null) {
            CachingMultiIndexReader[] readers = new CachingMultiIndexReader[]{this.indexRegister.getDefaultIndex().getIndexReader(), parentReader};
            reader = new CombinedIndexReader(readers);
        } else {
            reader = this.indexRegister.getDefaultIndex().getIndexReader();
        }
        return new JcrIndexReader((IndexReader)reader);
    }

    protected SortField[] createSortFields(QPath[] orderProps, boolean[] orderSpecs, FieldComparatorSource scs) throws RepositoryException {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            if (orderProps[i].getEntries().length == 1 && Constants.JCR_SCORE.equals((Object)orderProps[i].getName())) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            String jcrPath = this.npResolver.createJCRPath(orderProps[i]).getAsString(false);
            sortFields.add(new SortField(jcrPath, scs, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    protected Document createDocument(NodeData node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion, boolean loadAllProperties) throws RepositoryException {
        return this.createDocument(new NodeDataIndexing(node), nsMappings, indexFormatVersion, loadAllProperties, null);
    }

    protected Document createDocument(NodeDataIndexing node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion, boolean loadAllProperties, VolatileIndex volatileIndex) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.extractor);
        indexer.setSupportHighlighting(this.supportHighlighting);
        indexer.setIndexingConfiguration(this.indexingConfig);
        indexer.setIndexFormatVersion(indexFormatVersion);
        indexer.setLoadBatchingThreshold(this.indexingLoadBatchingThresholdProperty);
        indexer.setLoadPropertyByName(this.indexingLoadPropertyByName);
        indexer.setLoadAllProperties(loadAllProperties);
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc, loadAllProperties, volatileIndex);
        return doc;
    }

    public MultiIndex getIndex() {
        return this.indexRegister.getDefaultIndex();
    }

    public void setIndex(MultiIndex index) {
        this.indexRegister.setDefaultIndex(index);
    }

    public MultiIndex createNewIndex(String suffix) throws IOException {
        IndexInfos indexInfos = new IndexInfos();
        DefaultIndexUpdateMonitor indexUpdateMonitor = new DefaultIndexUpdateMonitor();
        IndexerIoModeHandler modeHandler = new IndexerIoModeHandler(IndexerIoMode.READ_WRITE);
        MultiIndex newIndex = new MultiIndex(this, this.getContext().getIndexingTree(), modeHandler, indexInfos, indexUpdateMonitor, this.cloneDirectoryManager(this.getDirectoryManager(), suffix));
        return newIndex;
    }

    protected IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings) {
        Element docElement = this.getIndexingConfigurationDOM();
        if (docElement == null) {
            return null;
        }
        try {
            IndexingConfiguration idxCfg = this.indexingConfigurationClass.newInstance();
            idxCfg.init(docElement, this.getContext(), namespaceMappings);
            return idxCfg;
        }
        catch (Exception e) {
            log.warn((Object)("Exception initializing indexing configuration from: " + this.indexingConfigPath), (Throwable)e);
            log.warn((Object)(this.indexingConfigPath + " ignored."));
            return null;
        }
    }

    protected SynonymProvider createSynonymProvider() {
        SynonymProvider sp = null;
        if (this.synonymProviderClass != null) {
            try {
                sp = this.synonymProviderClass.newInstance();
                sp.initialize(this.createSynonymProviderConfigResource());
            }
            catch (IOException e) {
                log.warn((Object)("Exception initializing synonym provider: " + String.valueOf(this.synonymProviderClass)), (Throwable)e);
                sp = null;
            }
            catch (InstantiationException e) {
                log.warn((Object)("Exception initializing synonym provider: " + String.valueOf(this.synonymProviderClass)), (Throwable)e);
                sp = null;
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Exception initializing synonym provider: " + String.valueOf(this.synonymProviderClass)), (Throwable)e);
                sp = null;
            }
        }
        return sp;
    }

    protected DirectoryManager createDirectoryManager() throws IOException {
        try {
            Class clazz = ClassLoading.forName((String)this.directoryManagerClass, (Object)this);
            if (!DirectoryManager.class.isAssignableFrom(clazz)) {
                throw new IOException(this.directoryManagerClass + " is not a DirectoryManager implementation");
            }
            DirectoryManager df = (DirectoryManager)clazz.newInstance();
            df.init(this);
            return df;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    protected DirectoryManager cloneDirectoryManager(DirectoryManager directoryManager, String suffix) throws IOException {
        try {
            DirectoryManager df = (DirectoryManager)directoryManager.getClass().newInstance();
            df.init(this.path + suffix);
            return df;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    protected InputStream createSynonymProviderConfigResource() throws IOException {
        if (this.synonymProviderConfigPath != null) {
            InputStream fsr;
            String separator = System.getProperty("file.separator");
            if (this.synonymProviderConfigPath.endsWith(System.getProperty("file.separator"))) {
                throw new IOException("Invalid synonymProviderConfigPath: " + this.synonymProviderConfigPath);
            }
            if (this.cfm == null) {
                int lastSeparator = this.synonymProviderConfigPath.lastIndexOf(separator);
                if (lastSeparator != -1) {
                    File root = new File(this.path, this.synonymProviderConfigPath.substring(0, lastSeparator));
                    fsr = new BufferedInputStream(new FileInputStream(new File(root, this.synonymProviderConfigPath.substring(lastSeparator + 1))));
                } else {
                    fsr = new BufferedInputStream(new FileInputStream(new File(this.synonymProviderConfigPath)));
                }
                this.synonymProviderConfigFs = fsr;
            } else {
                try {
                    fsr = this.cfm.getInputStream(this.synonymProviderConfigPath);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
            return fsr;
        }
        return null;
    }

    protected SpellChecker createSpellChecker() {
        SpellChecker spCheck = null;
        if (this.spellCheckerClass != null) {
            try {
                spCheck = this.spellCheckerClass.newInstance();
                spCheck.init(this, this.spellCheckerMinDistance, this.spellCheckerMorePopular);
            }
            catch (IOException e) {
                log.warn((Object)("Exception initializing spell checker: " + String.valueOf(this.spellCheckerClass)), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.warn((Object)("Exception initializing spell checker: " + String.valueOf(this.spellCheckerClass)), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Exception initializing spell checker: " + String.valueOf(this.spellCheckerClass)), (Throwable)e);
            }
        }
        return spCheck;
    }

    protected Element getIndexingConfigurationDOM() {
        if (this.indexingConfiguration == null && this.indexingConfigPath != null) {
            InputStream is = SearchIndex.class.getResourceAsStream(this.indexingConfigPath);
            if (is == null) {
                try {
                    is = this.cfm.getInputStream(this.indexingConfigPath);
                }
                catch (Exception e1) {
                    log.warn((Object)("Unable to load configuration " + this.indexingConfigPath));
                }
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new IndexingConfigurationEntityResolver());
                String content = Deserializer.resolveVariables((String)Utils.readStream((InputStream)is));
                InputSource source = new InputSource(new StringReader(content));
                this.indexingConfiguration = builder.parse(source).getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                log.warn((Object)"Unable to create XML parser", (Throwable)e);
            }
            catch (IOException e) {
                log.warn((Object)("Exception parsing " + this.indexingConfigPath), (Throwable)e);
            }
            catch (SAXException e) {
                log.warn((Object)("Exception parsing " + this.indexingConfigPath), (Throwable)e);
            }
        }
        return this.indexingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeAggregatedNodeIndexes(NodeData state, Document doc, boolean loadAllProperties, VolatileIndex volatileIndex) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                ArrayList fulltextTemp = new ArrayList();
                ItemDataConsumer ism = this.getContext().getItemStateManager();
                for (int i = 0; i < aggregateRules.length; ++i) {
                    PropertyData[] propStates;
                    boolean ruleMatched = false;
                    NodeData[] aggregates = aggregateRules[i].getAggregatedNodeStates(state);
                    if (aggregates != null) {
                        ruleMatched = true;
                        for (int j = 0; j < aggregates.length; ++j) {
                            Fieldable[] fulltextFields;
                            Document aDoc = this.createDocument(aggregates[j], this.getNamespaceMappings(), this.indexRegister.getDefaultIndex().getIndexFormatVersion(), loadAllProperties);
                            if (volatileIndex != null) {
                                volatileIndex.addAggregateIndexes(aDoc);
                            }
                            if ((fulltextFields = aDoc.getFieldables(FieldNames.FULLTEXT)) == null) continue;
                            for (int k = 0; k < fulltextFields.length; ++k) {
                                for (Fieldable fulltextField : fulltextFields) {
                                    doc.add(fulltextField);
                                }
                            }
                            doc.add((Fieldable)new Field(FieldNames.AGGREGATED_NODE_UUID, aggregates[j].getIdentifier(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                        }
                        Document fulltextFields = doc.getFieldables(FieldNames.FULLTEXT);
                        doc.removeFields(FieldNames.FULLTEXT);
                        Arrays.sort(fulltextFields, FIELDS_COMPARATOR_STORED);
                        for (Document f : fulltextFields) {
                            doc.add((Fieldable)f);
                        }
                    }
                    if ((propStates = aggregateRules[i].getAggregatedPropertyStates(state)) != null) {
                        ruleMatched = true;
                        for (int j = 0; j < propStates.length; ++j) {
                            PropertyData propState = propStates[j];
                            String namePrefix = FieldNames.createNamedValue(this.getNamespaceMappings().translateName(propState.getQPath().getName()), "");
                            NodeData parent = (NodeData)ism.getItemData(propState.getParentIdentifier());
                            Document aDoc = this.createDocument(parent, this.getNamespaceMappings(), this.getIndex().getIndexFormatVersion(), loadAllProperties);
                            try {
                                Fieldable[] fields = aDoc.getFieldables(FieldNames.PROPERTIES);
                                for (int k = 0; k < fields.length; ++k) {
                                    Fieldable field = fields[k];
                                    field.tokenStreamValue().incrementToken();
                                    CharTermAttribute term = (CharTermAttribute)field.tokenStreamValue().getAttribute(CharTermAttribute.class);
                                    PayloadAttribute payload = (PayloadAttribute)field.tokenStreamValue().getAttribute(PayloadAttribute.class);
                                    String value = new String(term.buffer(), 0, term.length());
                                    if (!value.startsWith(namePrefix)) continue;
                                    value = value.substring(namePrefix.length());
                                    QPath p = this.getRelativePath(state, propState);
                                    String path = this.getNamespaceMappings().translatePath(p);
                                    value = FieldNames.createNamedValue(path, value);
                                    term.setEmpty();
                                    term.append(value);
                                    doc.add((Fieldable)new Field(field.name(), (TokenStream)new SingletonTokenStream(term.toString(), payload.getPayload())));
                                    doc.add((Fieldable)new Field(FieldNames.AGGREGATED_NODE_UUID, parent.getIdentifier(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                                }
                                continue;
                            }
                            finally {
                                Util.disposeDocument(aDoc);
                            }
                        }
                    }
                    if (!ruleMatched) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.warn((Object)("Exception while building indexing aggregate for node with UUID: " + state.getIdentifier()), (Throwable)e);
            }
        }
    }

    protected QPath getRelativePath(NodeData nodeState, PropertyData propState) throws RepositoryException {
        throw new RepositoryException();
    }

    protected void retrieveAggregateRoot(NodeData state, Map<String, NodeData> map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                for (int i = 0; i < aggregateRules.length; ++i) {
                    NodeData root = aggregateRules[i].getAggregateRoot(state);
                    if (root == null) continue;
                    map.put(root.getIdentifier(), root);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Unable to get aggregate root for " + state.getIdentifier()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveAggregateRoot(Set<String> removedNodeIds, Map<String, NodeData> map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            long time = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            int found = 0;
            try {
                CachingMultiIndexReader reader = this.indexRegister.getDefaultIndex().getIndexReader();
                try {
                    Term aggregateUUIDs = new Term(FieldNames.AGGREGATED_NODE_UUID, "");
                    try (TermDocs tDocs = reader.termDocs();){
                        ItemDataConsumer ism = this.getContext().getItemStateManager();
                        for (String id : removedNodeIds) {
                            aggregateUUIDs = aggregateUUIDs.createTerm(id);
                            tDocs.seek(aggregateUUIDs);
                            while (tDocs.next()) {
                                Document doc = reader.document(tDocs.doc(), FieldSelectors.UUID);
                                String uuid = doc.get(FieldNames.UUID);
                                ItemData itd = ism.getItemData(uuid);
                                if (itd == null) continue;
                                if (!itd.isNode()) {
                                    throw new RepositoryException("Item with id:" + uuid + " is not a node");
                                }
                                map.put(uuid, (NodeData)itd);
                                ++found;
                            }
                        }
                    }
                }
                finally {
                    reader.release();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception while retrieving aggregate roots", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis() - time;
                log.debug("Retrieved {} aggregate roots in {} ms.", new Object[]{found, time});
            }
        }
    }

    public void setAnalyzer(String analyzerClassName) {
        try {
            Class analyzerClass = ClassLoading.forName((String)analyzerClassName, (Object)this);
            this.analyzer.setDefaultAnalyzer((Analyzer)analyzerClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Invalid Analyzer class: " + analyzerClassName), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)("Invalid Analyzer class: " + analyzerClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Invalid Analyzer class: " + analyzerClassName), (Throwable)e);
        }
    }

    public String getAnalyzer() {
        return ((Object)((Object)this.analyzer)).getClass().getName();
    }

    public void setPath(String path) {
        this.path = path.replace("${java.io.tmpdir}", System.getProperty("java.io.tmpdir"));
    }

    public String getPath() {
        return this.path;
    }

    public void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public int getMinMergeDocs() {
        return this.minMergeDocs;
    }

    public void setVolatileIdleTime(int volatileIdleTime) {
        this.volatileIdleTime = volatileIdleTime;
    }

    public int getVolatileIdleTime() {
        return this.volatileIdleTime;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setRespectDocumentOrder(boolean docOrder) {
        this.documentOrder = docOrder;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setForceConsistencyCheck(boolean b) {
        this.forceConsistencyCheck = b;
    }

    public boolean getForceConsistencyCheck() {
        return this.forceConsistencyCheck;
    }

    public void setAutoRepair(boolean b) {
        this.autoRepair = b;
    }

    public boolean getAutoRepair() {
        return this.autoRepair;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxFieldLength(int length) {
        this.maxFieldLength = length;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setResultFetchSize(int size) {
        this.resultFetchSize = size;
    }

    public int getResultFetchSize() {
        return this.resultFetchSize;
    }

    public void setExtractorPoolSize(int numThreads) {
        if (numThreads < 0) {
            numThreads = 0;
        }
        this.extractorPoolSize = numThreads;
    }

    public int getExtractorPoolSize() {
        return this.extractorPoolSize;
    }

    public void setExtractorBackLogSize(int backLog) {
        this.extractorBackLog = backLog;
    }

    public int getExtractorBackLogSize() {
        return this.extractorBackLog;
    }

    public void setExtractorTimeout(long timeout) {
        this.extractorTimeout = timeout;
    }

    public long getExtractorTimeout() {
        return this.extractorTimeout;
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public boolean getSupportHighlighting() {
        return this.supportHighlighting;
    }

    public void setExcerptProviderClass(String className) {
        try {
            Class clazz = ClassLoading.forName((String)className, (Object)this);
            if (ExcerptProvider.class.isAssignableFrom(clazz)) {
                this.excerptProviderClass = clazz;
            } else {
                log.warn("Invalid value for excerptProviderClass, {} does not implement ExcerptProvider interface.", new Object[]{className});
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for excerptProviderClass, class {} not found.", new Object[]{className});
        }
    }

    public String getExcerptProviderClass() {
        return this.excerptProviderClass.getName();
    }

    public void setIndexingConfiguration(String path) {
        this.indexingConfigPath = path;
    }

    public String getIndexingConfiguration() {
        return this.indexingConfigPath;
    }

    public void setIndexingConfigurationClass(String className) {
        try {
            Class clazz = ClassLoading.forName((String)className, (Object)this);
            if (IndexingConfiguration.class.isAssignableFrom(clazz)) {
                this.indexingConfigurationClass = clazz;
            } else {
                log.warn("Invalid value for indexingConfigurationClass, {} does not implement IndexingConfiguration interface.", new Object[]{className});
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for indexingConfigurationClass, class {} not found.", new Object[]{className});
        }
    }

    public String getIndexingConfigurationClass() {
        return this.indexingConfigurationClass.getName();
    }

    public void setSynonymProviderClass(String className) {
        try {
            Class clazz = ClassLoading.forName((String)className, (Object)this);
            if (SynonymProvider.class.isAssignableFrom(clazz)) {
                this.synonymProviderClass = clazz;
            } else {
                log.warn("Invalid value for synonymProviderClass, {} does not implement SynonymProvider interface.", new Object[]{className});
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for synonymProviderClass, class {} not found.", new Object[]{className});
        }
    }

    public String getSynonymProviderClass() {
        if (this.synonymProviderClass != null) {
            return this.synonymProviderClass.getName();
        }
        return null;
    }

    public void setSpellCheckerClass(String className) {
        try {
            Class clazz = ClassLoading.forName((String)className, (Object)this);
            if (SpellChecker.class.isAssignableFrom(clazz)) {
                this.spellCheckerClass = clazz;
            } else {
                log.warn("Invalid value for spellCheckerClass, {} does not implement SpellChecker interface.", new Object[]{className});
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for spellCheckerClass, class {} not found.", new Object[]{className});
        }
    }

    public void setSpellCheckerMorePopuar(boolean morePopular) {
        this.spellCheckerMorePopular = morePopular;
    }

    public void setSpellCheckerMinDistance(float minDistance) {
        this.spellCheckerMinDistance = minDistance;
    }

    public String getSpellCheckerClass() {
        if (this.spellCheckerClass != null) {
            return this.spellCheckerClass.getName();
        }
        return null;
    }

    public void setEnableConsistencyCheck(boolean b) {
        this.consistencyCheckEnabled = b;
    }

    public boolean getEnableConsistencyCheck() {
        return this.consistencyCheckEnabled;
    }

    public void setSynonymProviderConfigPath(String path) {
        this.synonymProviderConfigPath = path;
    }

    public String getSynonymProviderConfigPath() {
        return this.synonymProviderConfigPath;
    }

    public void setSimilarityClass(String className) {
        try {
            Class similarityClass = ClassLoading.forName((String)className, (Object)this);
            this.similarity = (Similarity)similarityClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Invalid Similarity class: " + className), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)("Invalid Similarity class: " + className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Invalid Similarity class: " + className), (Throwable)e);
        }
    }

    public String getSimilarityClass() {
        return this.similarity.getClass().getName();
    }

    public void setMaxVolatileIndexSize(long maxVolatileIndexSize) {
        this.maxVolatileIndexSize = maxVolatileIndexSize;
    }

    public long getMaxVolatileIndexSize() {
        return this.maxVolatileIndexSize;
    }

    public int getMaxVolatileTime() {
        return this.maxVolatileTime;
    }

    public void setMaxVolatileTime(int maxVolatileTime) {
        this.maxVolatileTime = maxVolatileTime;
    }

    public String getDirectoryManagerClass() {
        return this.directoryManagerClass;
    }

    public void setDirectoryManagerClass(String className) {
        this.directoryManagerClass = className;
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public int getReindexingPageSize() {
        return this.reindexingPageSize;
    }

    public boolean isRDBMSReindexing() {
        return this.rdbmsReindexing;
    }

    public boolean isAsyncReindexing() {
        return this.asyncReindexing;
    }

    public String getIndexRecoveryMode() {
        return this.indexRecoveryMode;
    }

    public String getIndexRecoveryStrategy() {
        return this.indexRecoveryStrategy;
    }

    public void setIndexRecoveryStrategy(String indexRecoveryStrategy) {
        this.indexRecoveryStrategy = indexRecoveryStrategy;
    }

    public RSyncConfiguration getRsyncConfiguration() {
        return this.rsyncConfiguration;
    }

    public void setRsyncConfiguration(RSyncConfiguration rsyncConfiguration) {
        this.rsyncConfiguration = rsyncConfiguration;
    }

    public void setTermInfosIndexDivisor(int termInfosIndexDivisor) {
        this.termInfosIndexDivisor = termInfosIndexDivisor;
    }

    public boolean isInitializeHierarchyCache() {
        return this.initializeHierarchyCache;
    }

    public void setInitializeHierarchyCache(boolean initializeHierarchyCache) {
        this.initializeHierarchyCache = initializeHierarchyCache;
    }

    public void setReindexingPageSize(int reindexingPageSize) {
        this.reindexingPageSize = reindexingPageSize;
    }

    public void setRDBMSReindexing(boolean rdbmsReindexing) {
        this.rdbmsReindexing = rdbmsReindexing;
    }

    public void setIndexRecoveryMode(String indexRecoveryMode) {
        this.indexRecoveryMode = indexRecoveryMode;
    }

    public void setAsyncReindexing(boolean asyncReindexing) {
        this.asyncReindexing = asyncReindexing;
    }

    private void checkOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    @Override
    public void logErrorChanges(Set<String> removed, Set<String> added) throws IOException {
        this.logErrorChanges(this.errorLog, removed, added);
    }

    public void logErrorChanges(ErrorLog errorLog, Set<String> removed, Set<String> added) throws IOException {
        if (errorLog != null) {
            errorLog.writeChanges(removed, added);
        }
    }

    public ErrorLog doInitErrorLog(String path) throws IOException {
        File file = new File(new File(path), ERROR_LOG);
        return new ErrorLog(file, this.errorLogfileSize);
    }

    private void recoverErrorLog(ErrorLog errlog) throws IOException, RepositoryException {
        HashSet<String> rem = new HashSet<String>();
        final HashSet<String> add = new HashSet<String>();
        errlog.readChanges(rem, add);
        if (rem.isEmpty() && add.isEmpty()) {
            return;
        }
        Iterator<String> removedStates = rem.iterator();
        Iterator<NodeData> addedStates = new Iterator<NodeData>(){
            private final Iterator<String> iter;
            {
                this.iter = add.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public NodeData next() {
                while (this.iter.hasNext()) {
                    String id = this.iter.next();
                    try {
                        ItemData item = SearchIndex.this.getContext().getItemStateManager().getItemData(id);
                        if (item != null) {
                            if (item.isNode()) {
                                return (NodeData)item;
                            }
                            log.warn((Object)("Node expected but property found with id " + id + ". Skipping " + item.getQPath().getAsString()));
                            continue;
                        }
                        log.warn((Object)("Unable to recovery node index " + id + ". Node not found."));
                    }
                    catch (RepositoryException e) {
                        log.error((Object)("ErrorLog recovery error. Item id " + id + ". " + String.valueOf((Object)e)), (Throwable)e);
                    }
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        this.updateNodes(removedStates, addedStates);
        errlog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryHits executeQuery(Query query) throws IOException {
        this.waitForResuming();
        this.checkOpen();
        this.workingThreads.incrementAndGet();
        try {
            IndexReader reader = this.getIndexReader(true);
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setSimilarity(this.getSimilarity());
            LuceneQueryHits luceneQueryHits = new LuceneQueryHits(reader, searcher, query, true);
            return luceneQueryHits;
        }
        finally {
            this.workingThreads.decrementAndGet();
            if (this.isSuspended.get() && this.workingThreads.get() == 0) {
                AtomicInteger atomicInteger = this.workingThreads;
                synchronized (atomicInteger) {
                    this.workingThreads.notifyAll();
                }
            }
        }
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        try {
            if (mode == IndexerIoMode.READ_WRITE) {
                log.info((Object)"Processing error log ...");
                this.recoverErrorLog(this.errorLog);
            }
        }
        catch (IOException e) {
            log.error((Object)("Can not recover error log. On changed mode " + String.valueOf((Object)mode)), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error((Object)"Can not recover error log.", (Throwable)e);
        }
    }

    @Override
    public void setOnline(boolean isOnline, boolean allowQuery, boolean dropStaleIndexes) throws IOException {
        this.checkOpen();
        if (isOnline) {
            this.allowQuery.set(true);
        } else {
            this.allowQuery.set(allowQuery);
        }
        this.indexRegister.getDefaultIndex().setOnline(isOnline, dropStaleIndexes);
    }

    @Override
    public boolean isOnline() {
        return this.indexRegister.getDefaultIndex().isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws SuspendException {
        this.latcher.set(new CountDownLatch(1));
        this.isSuspended.set(true);
        if (this.workingThreads.get() > 0) {
            AtomicInteger atomicInteger = this.workingThreads;
            synchronized (atomicInteger) {
                while (this.workingThreads.get() > 0) {
                    try {
                        this.workingThreads.wait();
                    }
                    catch (InterruptedException e) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        this.closeAndKeepWaitingThreads(false);
    }

    @Override
    public void resume() throws ResumeException {
        try {
            this.closed.set(false);
            this.doInit();
            this.resumeWaitingThreads();
            this.isSuspended.set(false);
        }
        catch (IOException e) {
            throw new ResumeException(e);
        }
        catch (RepositoryException e) {
            throw new ResumeException(e);
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    void waitForResuming() throws IOException {
        if (this.isSuspended.get()) {
            try {
                this.latcher.get().await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    private void resumeWaitingThreads() {
        if (this.latcher.get() != null) {
            this.latcher.get().countDown();
        }
    }

    public Integer getIndexingThreadPoolSize() {
        return this.indexingThreadPoolSize;
    }

    public void setIndexingThreadPoolSize(Integer indexingThreadPoolSize) {
        this.indexingThreadPoolSize = indexingThreadPoolSize;
    }

    public boolean isIndexingLoadBatchingThresholdDynamic() {
        return this.indexingLoadBatchingThresholdDynamic;
    }

    public void setIndexingLoadBatchingThresholdDynamic(boolean indexingLoadBatchingThresholdDynamic) {
        this.indexingLoadBatchingThresholdDynamic = indexingLoadBatchingThresholdDynamic;
    }

    public long getIndexingLoadBatchingThresholdTTL() {
        return this.indexingLoadBatchingThresholdTTL;
    }

    public void setIndexingLoadBatchingThresholdTTL(long indexingLoadBatchingThresholdTTL) {
        this.indexingLoadBatchingThresholdTTL = indexingLoadBatchingThresholdTTL;
    }

    public int getIndexingLoadBatchingThresholdProperty() {
        return this.indexingLoadBatchingThresholdProperty;
    }

    public void setIndexingLoadBatchingThresholdProperty(int indexingLoadBatchingThresholdProperty) {
        this.indexingLoadBatchingThresholdProperty = indexingLoadBatchingThresholdProperty;
    }

    public int getIndexingLoadBatchingThresholdNode() {
        return this.indexingLoadBatchingThresholdNode;
    }

    public void setIndexingLoadBatchingThresholdNode(int indexingLoadBatchingThresholdNode) {
        this.indexingLoadBatchingThresholdNode = indexingLoadBatchingThresholdNode;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public IndexRegister getIndexRegister() {
        return this.indexRegister;
    }

    static {
        FIELDS_COMPARATOR_STORED = new Comparator<Fieldable>(){

            @Override
            public int compare(Fieldable o1, Fieldable o2) {
                return Boolean.valueOf(o2.isStored()).compareTo(o1.isStored());
            }
        };
    }

    public class IndexRegister {
        private final Map<MultiIndex, ErrorLog> indexList = new HashMap<MultiIndex, ErrorLog>();
        private MultiIndex defaultIndex;

        public IndexRegister(SearchIndex this$0, MultiIndex defaultIndex) {
            this.defaultIndex = defaultIndex;
        }

        public void register(MultiIndex index, ErrorLog errorLog) throws IOException {
            this.indexList.put(index, errorLog);
        }

        public void unregister(MultiIndex multiIndex) throws IOException {
            multiIndex.close();
            ErrorLog errorLog = this.indexList.get(multiIndex);
            errorLog.flush();
            errorLog.close();
            this.indexList.remove(multiIndex);
        }

        public Set<MultiIndex> getIndexList() {
            return this.indexList.keySet();
        }

        public ErrorLog getErrorLogs(MultiIndex index) {
            return this.indexList.get(index);
        }

        public MultiIndex getDefaultIndex() {
            return this.defaultIndex;
        }

        public void setDefaultIndex(MultiIndex index) {
            this.defaultIndex = index;
        }
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver,
    MultiIndexReader {
        private final CachingMultiIndexReader[] subReaders;
        private int[] starts;

        public CombinedIndexReader(CachingMultiIndexReader[] indexReaders) {
            super((IndexReader[])indexReaders);
            this.subReaders = indexReaders;
            this.starts = new int[this.subReaders.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.starts[i] = maxDoc;
                maxDoc += this.subReaders[i].maxDoc();
            }
            this.starts[this.subReaders.length] = maxDoc;
        }

        @Override
        public int[] getParents(int n, int[] docNumbers) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumbers(this, docNumbers);
        }

        @Override
        public IndexReader[] getIndexReaders() {
            IndexReader[] readers = new IndexReader[this.subReaders.length];
            System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
            return readers;
        }

        @Override
        public void release() throws IOException {
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.subReaders[i].release();
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof CombinedIndexReader) {
                CombinedIndexReader other = (CombinedIndexReader)obj;
                return Arrays.equals(this.subReaders, other.subReaders);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                hash = 31 * hash + this.subReaders[i].hashCode();
            }
            return hash;
        }

        @Override
        public ForeignSegmentDocId createDocId(String uuid) throws IOException {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                ForeignSegmentDocId doc = subReader.createDocId(uuid);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        @Override
        public int getDocumentNumber(ForeignSegmentDocId docId) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                int realDoc = subReader.getDocumentNumber(docId);
                if (realDoc < 0) continue;
                return realDoc + this.starts[i];
            }
            return -1;
        }
    }
}

