/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import java.time.Instant;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.opengis.referencing.datum.TemporalDatum;

class TimeEncoding
extends SurjectiveConverter<String, Instant> {
    static final CommonCRS.Temporal DEFAULT = CommonCRS.Temporal.TRUNCATED_JULIAN;
    static final TimeEncoding ABSOLUTE = new TimeEncoding(DEFAULT.datum(), Units.DAY){

        @Override
        public Instant apply(String string) {
            return StandardDateFormat.parseInstantUTC((CharSequence)string);
        }
    };
    private final long origin;
    private final double interval;

    TimeEncoding(TemporalDatum temporalDatum, Unit<Time> unit) {
        this.origin = temporalDatum.getOrigin().getTime();
        this.interval = unit.getConverterTo(Units.MILLISECOND).convert(1.0);
    }

    public final Class<String> getSourceClass() {
        return String.class;
    }

    public final Class<Instant> getTargetClass() {
        return Instant.class;
    }

    public Instant apply(String string) {
        double d = Double.parseDouble(string) * this.interval;
        long l = Math.round(d);
        return Instant.ofEpochMilli(l + this.origin).plusNanos(Math.round((d - (double)l) * 1000000.0));
    }

    final double toCRS(long l) {
        return (double)(l - this.origin) / this.interval;
    }
}

