/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.RelatedDefinition;

public abstract class AbstractDefinitionComparator<T extends ItemDefinitionData> {
    public abstract PlainChangesLog compare(NodeTypeData var1, T[] var2, T[] var3) throws ConstraintViolationException, RepositoryException;

    protected void init(T[] ancestorDefinition, T[] recipientDefinition, List<T> sameDefinitionData, List<RelatedDefinition<T>> changedDefinitionData, List<T> newDefinitionData, List<T> removedDefinitionData) {
        int j;
        int i;
        for (i = 0; i < recipientDefinition.length; ++i) {
            boolean isNew = true;
            for (j = 0; j < ancestorDefinition.length; ++j) {
                if (!((ItemDefinitionData)recipientDefinition[i]).getName().equals((Object)((ItemDefinitionData)ancestorDefinition[j]).getName())) continue;
                isNew = false;
                if (((ItemDefinitionData)recipientDefinition[i]).equals(ancestorDefinition[j])) {
                    sameDefinitionData.add(recipientDefinition[i]);
                    continue;
                }
                RelatedDefinition<T> relatedDefinition = new RelatedDefinition<T>(ancestorDefinition[j], recipientDefinition[i]);
                changedDefinitionData.add(relatedDefinition);
            }
            if (!isNew) continue;
            newDefinitionData.add(recipientDefinition[i]);
        }
        for (i = 0; i < ancestorDefinition.length; ++i) {
            boolean isRemoved = true;
            for (j = 0; j < recipientDefinition.length && isRemoved; ++j) {
                if (!((ItemDefinitionData)recipientDefinition[j]).getName().equals((Object)((ItemDefinitionData)ancestorDefinition[i]).getName())) continue;
                isRemoved = false;
                break;
            }
            if (!isRemoved) continue;
            removedDefinitionData.add(ancestorDefinition[i]);
        }
    }

    protected boolean isResidualMatch(InternalQName itemName, T[] recipientDefinition) {
        boolean containsResidual = false;
        for (int i = 0; i < recipientDefinition.length; ++i) {
            if (itemName.equals((Object)((ItemDefinitionData)recipientDefinition[i]).getName())) {
                return false;
            }
            if (!Constants.JCR_ANY_NAME.equals((Object)((ItemDefinitionData)recipientDefinition[i]).getName())) continue;
            containsResidual = true;
        }
        return containsResidual;
    }

    protected boolean isNonResidualMatch(InternalQName itemName, T[] recipientDefinition) {
        boolean isMatch = false;
        for (int i = 0; i < recipientDefinition.length; ++i) {
            if (!itemName.equals((Object)((ItemDefinitionData)recipientDefinition[i]).getName())) continue;
            return true;
        }
        return isMatch;
    }
}

