/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.ReaderUtil;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;

public final class JcrIndexReader
extends FilterIndexReader
implements HierarchyResolver,
MultiIndexReader {
    private final HierarchyResolver resolver;
    private final MultiIndexReader reader;

    public JcrIndexReader(IndexReader in) {
        super(in);
        if (!(in instanceof MultiIndexReader)) {
            throw new IllegalArgumentException("IndexReader must also implement MultiIndexReader");
        }
        if (!(in instanceof HierarchyResolver)) {
            throw new IllegalArgumentException("IndexReader must also implement HierarchyResolver");
        }
        this.resolver = (HierarchyResolver)in;
        this.reader = (MultiIndexReader)in;
    }

    protected void doClose() throws IOException {
        this.reader.release();
    }

    @Override
    public int[] getParents(int n, int[] docNumbers) throws IOException {
        return this.resolver.getParents(n, docNumbers);
    }

    @Override
    public IndexReader[] getIndexReaders() {
        return this.reader.getIndexReaders();
    }

    @Override
    public ForeignSegmentDocId createDocId(String uuid) throws IOException {
        return this.reader.createDocId(uuid);
    }

    @Override
    public int getDocumentNumber(ForeignSegmentDocId docId) throws IOException {
        return this.reader.getDocumentNumber(docId);
    }

    @Override
    public void release() throws IOException {
        this.reader.release();
    }

    public IndexReader[] getSequentialSubReaders() {
        return null;
    }

    public FieldInfos getFieldInfos() {
        return ReaderUtil.getMergedFieldInfos((IndexReader)this.in);
    }
}

