/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import javax.jcr.RepositoryException;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.AbstractRepositorySuspender;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositorySuspendController")})
public class RepositorySuspendController
extends AbstractRepositorySuspender
implements Startable {
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositorySuspendController");

    public RepositorySuspendController(ManageableRepository repository) {
        super(repository);
    }

    @Managed
    @ManagedDescription(value="Suspend repository which means that allow only read operations. All writing threads will wait until resume operations invoked.")
    public String suspend() {
        try {
            this.suspendRepository();
        }
        catch (RepositoryException e) {
            log.error((Object)("An exception occured: " + e.getMessage()));
        }
        return this.getRepositoryStateTitle();
    }

    @Managed
    @ManagedDescription(value="Resume repository. All previously suspended threads continue working.")
    public String resume() {
        try {
            this.resumeRepository();
        }
        catch (RepositoryException e) {
            log.error((Object)("An exception occured: " + e.getMessage()));
        }
        return this.getRepositoryStateTitle();
    }

    @Managed
    @ManagedDescription(value="Returns repository state.")
    public String getState() {
        return this.getRepositoryStateTitle();
    }

    public void start() {
    }

    public void stop() {
    }
}

