/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public abstract class PlanarImage
implements RenderedImage {
    public static final String GRID_GEOMETRY_KEY = "org.apache.sis.GridGeometry";
    public static final String POSITIONAL_ACCURACY_KEY = "org.apache.sis.PositionalAccuracy";
    public static final String SAMPLE_RESOLUTIONS_KEY = "org.apache.sis.SampleResolution";
    public static final String STATISTICS_KEY = "org.apache.sis.Statistics";
    public static final String MASK_KEY = "org.apache.sis.Mask";

    protected PlanarImage() {
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    @Override
    public Object getProperty(String string) {
        ArgumentChecks.ensureNonNull((String)"key", (Object)string);
        return Image.UndefinedProperty;
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    public Rectangle getBounds() {
        return ImageUtilities.getBounds(this);
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getNumXTiles() {
        return Numerics.ceilDiv((int)this.getWidth(), (int)this.getTileWidth());
    }

    @Override
    public int getNumYTiles() {
        return Numerics.ceilDiv((int)this.getHeight(), (int)this.getTileHeight());
    }

    @Override
    public int getTileGridXOffset() {
        return Math.toIntExact((long)this.getMinX() - JDK9.multiplyFull((int)this.getMinTileX(), (int)this.getTileWidth()));
    }

    @Override
    public int getTileGridYOffset() {
        return Math.toIntExact((long)this.getMinY() - JDK9.multiplyFull((int)this.getMinTileY(), (int)this.getTileHeight()));
    }

    private WritableRaster createWritableRaster(Rectangle rectangle) {
        SampleModel sampleModel = this.getSampleModel();
        if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
            sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        }
        return Raster.createWritableRaster(sampleModel, rectangle.getLocation());
    }

    @Override
    public Raster getData() {
        Rectangle rectangle = this.getBounds();
        WritableRaster writableRaster = this.createWritableRaster(rectangle);
        this.copyData(rectangle, writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        ArgumentChecks.ensureNonNull((String)"aoi", (Object)rectangle);
        if (!this.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(Errors.format((short)119));
        }
        WritableRaster writableRaster = this.createWritableRaster(rectangle);
        this.copyData(rectangle, writableRaster);
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (writableRaster != null) {
            rectangle = writableRaster.getBounds();
            ImageUtilities.clipBounds(this, rectangle);
        } else {
            rectangle = this.getBounds();
            writableRaster = this.createWritableRaster(rectangle);
        }
        if (!rectangle.isEmpty()) {
            this.copyData(rectangle, writableRaster);
        }
        return writableRaster;
    }

    private void copyData(final Rectangle rectangle, final WritableRaster writableRaster) {
        TileOpExecutor tileOpExecutor = new TileOpExecutor(this, rectangle){
            private Object buffer;
            private int bufferCapacity;

            @Override
            protected void readFrom(Raster raster) {
                Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                int n = ImageUtilities.prepareTransferRegion(rectangle2, raster.getTransferType());
                int n2 = rectangle2.width * rectangle2.height;
                if (n2 > this.bufferCapacity) {
                    this.bufferCapacity = n2;
                    this.buffer = null;
                }
                while (rectangle2.y < n) {
                    int n3 = Math.min(rectangle2.height, n - rectangle2.y);
                    this.buffer = raster.getDataElements(rectangle2.x, rectangle2.y, rectangle2.width, n3, this.buffer);
                    writableRaster.setDataElements(rectangle2.x, rectangle2.y, rectangle2.width, n3, this.buffer);
                    rectangle2.y += n3;
                }
            }
        };
        tileOpExecutor.readFrom(this);
    }

    Disposable prefetch(Rectangle rectangle) {
        return null;
    }

    public String verify() {
        long l;
        int n = this.getTileWidth();
        int n2 = this.getTileHeight();
        SampleModel sampleModel = this.getSampleModel();
        if (sampleModel != null) {
            ColorModel colorModel = this.getColorModel();
            if (colorModel != null && !colorModel.isCompatibleSampleModel(sampleModel)) {
                return "colorModel";
            }
            if (sampleModel.getWidth() < n) {
                return "tileWidth";
            }
            if (sampleModel.getHeight() < n2) {
                return "tileHeight";
            }
        }
        if ((l = JDK9.multiplyFull((int)this.getNumXTiles(), (int)n) - (long)this.getWidth()) != 0L) {
            return l >= 0L && l < (long)n ? "width" : "numXTiles";
        }
        l = JDK9.multiplyFull((int)this.getNumYTiles(), (int)n2) - (long)this.getHeight();
        if (l != 0L) {
            return l >= 0L && l < (long)n2 ? "height" : "numYTiles";
        }
        if (JDK9.multiplyFull((int)this.getMinTileX(), (int)n) + (long)this.getTileGridXOffset() != (long)this.getMinX()) {
            return "tileX";
        }
        if (JDK9.multiplyFull((int)this.getMinTileY(), (int)n2) + (long)this.getTileGridYOffset() != (long)this.getMinY()) {
            return "tileY";
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder;
        block12: {
            Object object;
            stringBuilder = new StringBuilder(100).append(Classes.getShortClassName((Object)this)).append("[(").append(this.getWidth()).append(" \u00d7 ").append(this.getHeight()).append(") pixels");
            SampleModel sampleModel = this.getSampleModel();
            if (sampleModel != null) {
                stringBuilder.append(" \u00d7 ").append(sampleModel.getNumBands()).append(" bands");
                object = ImageUtilities.getDataTypeName(sampleModel);
                if (object != null) {
                    stringBuilder.append(" of type ").append((String)object);
                }
            }
            if ((object = this.getColorModel()) != null) {
                String string;
                stringBuilder.append("; ");
                if (object instanceof IndexColorModel) {
                    stringBuilder.append(((IndexColorModel)object).getMapSize()).append(" indexed colors");
                } else {
                    ColorModelFactory.formatDescription(((ColorModel)object).getColorSpace(), stringBuilder);
                }
                switch (((ColorModel)object).getTransparency()) {
                    case 1: {
                        string = "opaque";
                        break;
                    }
                    case 3: {
                        string = "translucent";
                        break;
                    }
                    case 2: {
                        string = "bitmask transparency";
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                stringBuilder.append("; ").append(string);
            }
        }
        int n = this.getNumXTiles();
        int n2 = this.getNumYTiles();
        if (n != 1 || n2 != 1) {
            stringBuilder.append("; ").append(n).append(" \u00d7 ").append(n2).append(" tiles");
        }
        stringBuilder.append(']');
        String string = this.verify();
        if (string != null) {
            stringBuilder.append(System.lineSeparator()).append("\u2514\u2500").append(Messages.format((short)34, (Object)string));
        }
        return stringBuilder.toString();
    }
}

