/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractNamespaceMappings;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileBasedNamespaceMappings
extends AbstractNamespaceMappings {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.NamespaceMappings");
    private final File storage;
    private Map<String, String> prefixToURI = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
    }

    @Override
    public synchronized String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return this.prefixToURI.get(prefix);
    }

    @Override
    public synchronized String getNamespacePrefixByURI(String uri) throws NamespaceException {
        String prefix = this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug((Object)("adding new namespace mapping: " + prefix + " -> " + uri));
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, (Throwable)e);
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.storage.exists()) {
            try (FileInputStream in = new FileInputStream(this.storage);){
                Properties props = new Properties();
                log.debug((Object)"loading namespace mappings...");
                props.load(in);
                for (String string : props.keySet()) {
                    String uri = props.getProperty(string);
                    log.debug((Object)(string + " -> " + uri));
                    this.prefixToURI.put(string, uri);
                    this.uriToPrefix.put(uri, string);
                }
                this.prefixCount = props.size();
                log.debug((Object)"namespace mappings loaded.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Properties props = new Properties();
        for (String prefix : this.prefixToURI.keySet()) {
            String uri = this.prefixToURI.get(prefix);
            props.setProperty(prefix, uri);
        }
        try (OutputStream out = new FileOutputStream(this.storage);){
            out = new BufferedOutputStream(out);
            props.store(out, null);
        }
    }

    @Override
    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.prefixToURI.keySet().toArray(new String[this.prefixToURI.keySet().size()]);
    }
}

