/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.geoapi.filter.SortBy;
import org.apache.sis.internal.geoapi.filter.SortProperty;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;

public final class SortByComparator<R>
implements SortBy<R>,
Serializable {
    private static final long serialVersionUID = -7964849249532212389L;
    private final SortProperty<R>[] properties;

    private SortByComparator(SortProperty<R> sortProperty) {
        ArgumentChecks.ensureNonNullElement((String)"properties", (int)0, sortProperty);
        this.properties = new SortProperty[]{sortProperty};
    }

    private SortByComparator(Map<?, SortProperty<R>> map) {
        this.properties = map.values().toArray(new SortProperty[map.size()]);
    }

    public static <R> SortByComparator<R> create(SortProperty<R>[] sortPropertyArray) {
        switch (sortPropertyArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new SortByComparator<R>(sortPropertyArray[0]);
            }
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        SortByComparator.addAll(Arrays.asList(sortPropertyArray), linkedHashMap);
        return new SortByComparator<R>(linkedHashMap);
    }

    public static <R> SortBy<? super R> concatenate(SortBy<? super R> sortBy, Comparator<? super R> comparator) {
        SortByComparator<R> sortByComparator;
        if (comparator instanceof SortBy) {
            sortByComparator = (SortByComparator<R>)comparator;
        } else if (comparator instanceof SortProperty) {
            sortByComparator = new SortByComparator<R>((SortProperty)comparator);
        } else {
            return null;
        }
        if (sortBy == null) {
            return sortByComparator;
        }
        return SortByComparator.concatenate(sortBy, sortByComparator);
    }

    public static <R> SortBy<R> concatenate(SortBy<R> sortBy, SortBy<R> sortBy2) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        SortByComparator.addAll(sortBy.getSortProperties(), linkedHashMap);
        SortByComparator.addAll(sortBy2.getSortProperties(), linkedHashMap);
        return new SortByComparator<R>(linkedHashMap);
    }

    private static <R> void addAll(List<SortProperty<R>> list, Map<ValueReference<? super R, ?>, SortProperty<R>> map) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SortProperty<R> sortProperty = list.get(i);
            ArgumentChecks.ensureNonNullElement((String)"properties", (int)i, sortProperty);
            map.putIfAbsent(sortProperty.getValueReference(), sortProperty);
        }
    }

    @Override
    public List<SortProperty<R>> getSortProperties() {
        return UnmodifiableArrayList.wrap((Object[])this.properties);
    }

    @Override
    public int compare(R r, R r2) {
        for (SortProperty<R> sortProperty : this.properties) {
            int n = sortProperty.compare(r, r2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public Comparator<R> thenComparing(Comparator<? super R> comparator) {
        if (comparator instanceof SortBy) {
            return SortByComparator.concatenate(this, (SortBy)comparator);
        }
        return SortBy.super.thenComparing(comparator);
    }
}

