/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.config;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

class ConfigCatalogRule
extends Rule {
    private final String catalogClass;
    private final String nameAttribute;

    ConfigCatalogRule(String nameAttribute, String catalogClass) {
        this.nameAttribute = nameAttribute;
        this.catalogClass = catalogClass;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        CatalogFactory factory = CatalogFactory.getInstance();
        String nameValue = attributes.getValue(this.nameAttribute);
        Catalog catalog = nameValue == null ? factory.getCatalog() : factory.getCatalog(nameValue);
        if (catalog == null) {
            Catalog digesterCatalog;
            Class<?> clazz = this.digester.getClassLoader().loadClass(this.catalogClass);
            catalog = digesterCatalog = (Catalog)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (nameValue == null) {
                factory.setCatalog(catalog);
            } else {
                factory.addCatalog(nameValue, catalog);
            }
        }
        this.digester.push(catalog);
    }
}

