/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimpleChangedSizeHandler;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class ReferencePropertyRemover
extends AbstractInconsistencyRepair {
    private final NodeTypeDataManager nodeTypeManager;

    public ReferencePropertyRemover(WorkspaceStorageConnectionFactory connFactory, JDBCDataContainerConfig containerConfig, NodeTypeDataManager nodeTypeManager) {
        super(connFactory, containerConfig);
        this.nodeTypeManager = nodeTypeManager;
    }

    @Override
    void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            PropertyDefinitionDatas def;
            String propertyId;
            String parentId;
            int type;
            int version;
            boolean multiValued;
            PropertyData data;
            block14: {
                data = (PropertyData)conn.getItemData(this.getIdentifier(resultSet, "ID"));
                multiValued = resultSet.getBoolean("P_MULTIVALUED");
                version = resultSet.getInt("VERSION");
                type = resultSet.getInt("P_TYPE");
                parentId = this.getIdentifier(resultSet, "PARENT_ID");
                propertyId = this.getIdentifier(resultSet, "ID");
                InternalQName propertyName = InternalQName.parse(resultSet.getString("NAME"));
                def = null;
                try {
                    NodeData parent = (NodeData)conn.getItemData(parentId);
                    def = this.nodeTypeManager.getPropertyDefinitions(propertyName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
                }
                catch (PrimaryTypeNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block14;
                    LOG.trace((Object)e.getMessage(), (Throwable)((Object)e));
                }
            }
            if (def == null || def.getDefinition(multiValued) == null || def.getDefinition(multiValued).isResidualSet() || !def.getDefinition(multiValued).isMandatory()) {
                if (def.getDefinition(multiValued).isMultiple()) {
                    ArrayList<ValueData> list = new ArrayList<ValueData>();
                    for (ValueData v : data.getValues()) {
                        String vData = new String(v.getAsByteArray(), "UTF-8");
                        if (vData == null || vData.isEmpty()) continue;
                        list.add(v);
                    }
                    if (list.isEmpty()) {
                        conn.delete(data, new SimpleChangedSizeHandler());
                    } else {
                        QPath path = new QPath(new QPathEntry[]{this.getQPathEntry(resultSet)});
                        TransientPropertyData newData = new TransientPropertyData(path, propertyId, version, type, parentId, true, list);
                        conn.update(newData, new SimpleChangedSizeHandler());
                    }
                } else {
                    conn.delete(data, new SimpleChangedSizeHandler());
                }
            }
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        catch (IllegalNameException e) {
            throw new SQLException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }
}

