/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.serialization.SerializationSpoolFile;
import org.exoplatform.services.jcr.util.IdGenerator;

public class PersistedValueDataWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ObjectWriter out, PersistedValueData vd) throws IOException {
        out.writeInt(11);
        out.writeInt(vd.getOrderNumber());
        boolean isByteArray = vd.isByteArray();
        out.writeBoolean(isByteArray);
        if (isByteArray) {
            byte[] data = vd.getAsByteArray();
            out.writeInt(data.length);
            out.write(data);
        } else {
            FilePersistedValueData streamed = (FilePersistedValueData)vd;
            InputStream in = null;
            if (streamed.getFile() == null && vd instanceof StreamPersistedValueData) {
                if (((StreamPersistedValueData)vd).getTempFile() != null) {
                    in = new FileInputStream(((StreamPersistedValueData)vd).getTempFile());
                }
            } else {
                in = streamed.getAsStream();
            }
            if (streamed.getFile() instanceof SerializationSpoolFile) {
                SerializationSpoolFile ssf = (SerializationSpoolFile)streamed.getFile();
                out.writeString(ssf.getId());
                out.writeLong(0L);
            } else {
                String id = IdGenerator.generate();
                out.writeString(id);
                if (in == null) {
                    out.writeLong(-1L);
                } else {
                    out.writeLong(vd.getLength());
                    try {
                        byte[] buf = new byte[2048];
                        int l = 0;
                        while ((l = in.read(buf)) >= 0) {
                            out.write(buf, 0, l);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
            }
        }
    }
}

