/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.ZonedGridSystem;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

@XmlTransient
public final class ZonedTransverseMercator
extends AbstractProvider {
    private static final long serialVersionUID = 4555131921419380461L;
    public static final ParameterDescriptor<Double> INITIAL_LONGITUDE;
    public static final ParameterDescriptor<Double> ZONE_WIDTH;
    private static final ParameterDescriptorGroup PARAMETERS;

    public ZonedTransverseMercator() {
        super(2, 2, PARAMETERS);
    }

    public Class<? extends Projection> getOperationType() {
        return Projection.class;
    }

    @Override
    public final int getEllipsoidsMask() {
        return 1;
    }

    @Override
    public final MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        return new ZonedGridSystem(this, Parameters.castOrWrap(parameterValueGroup), mathTransformFactory);
    }

    static {
        ParameterBuilder parameterBuilder = ZonedTransverseMercator.builder();
        INITIAL_LONGITUDE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8830")).addName("Initial longitude")).createBounded(-180.0, 180.0, -180.0, Units.DEGREE);
        ZONE_WIDTH = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8831")).addName("Zone width")).createStrictlyPositive(6.0, Units.DEGREE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9824")).addName("Transverse Mercator Zoned Grid System")).createGroupForMapProjection(TransverseMercator.LATITUDE_OF_ORIGIN, INITIAL_LONGITUDE, ZONE_WIDTH, TransverseMercator.SCALE_FACTOR, TransverseMercator.FALSE_EASTING, TransverseMercator.FALSE_NORTHING);
    }
}

