/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.script.groovy.GroovyScriptJarJarPlugin;
import org.exoplatform.services.script.groovy.jarjar.JarJarClassLoader;

@DefinitionByType
public class GroovyScriptInstantiator {
    private static final Log LOG = ExoLogger.getLogger(GroovyScriptInstantiator.class);
    private ExoContainer container;
    private Map<String, String> mapping;
    private static final ConstructorsComparator COMPARATOR = new ConstructorsComparator();

    public GroovyScriptInstantiator(ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        this.mapping = Collections.synchronizedMap(new HashMap());
    }

    public Object instantiateScript(String spec) throws MalformedURLException, IOException {
        return this.instantiateScript(new URL(spec));
    }

    public Object instantiateScript(URL url) throws IOException {
        String name = url.toString();
        return this.instantiateScript(new BufferedInputStream(url.openStream()), name);
    }

    public Object instantiateScript(InputStream stream) throws IOException {
        return this.instantiateScript(stream, null);
    }

    public Object instantiateScript(InputStream stream, String name) throws IOException {
        GroovyClassLoader loader;
        if (this.mapping.size() > 0) {
            JarJarClassLoader jarjarLoader = new JarJarClassLoader();
            jarjarLoader.addMapping(this.mapping);
            loader = jarjarLoader;
        } else {
            loader = new GroovyClassLoader();
        }
        return this.instantiateScript(stream, name, loader);
    }

    public Object instantiateScript(InputStream stream, String name, GroovyClassLoader loader) throws IOException {
        if (loader == null) {
            loader = new GroovyClassLoader();
        }
        Class clazz = null;
        GroovyClassLoader fLoader = loader;
        clazz = fLoader.parseClass(IOUtil.getStreamContentAsString((InputStream)stream));
        try {
            Object object = this.createObject(clazz);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate groovy script: " + e.getMessage(), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object instantiateScript(GroovyCodeSource codeSource, GroovyClassLoader loader) {
        if (loader == null) {
            loader = new GroovyClassLoader();
        }
        GroovyClassLoader fLoader = loader;
        Class clazz = fLoader.parseClass(codeSource);
        try {
            return this.createObject(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate groovy script: " + e.getMessage(), e);
        }
    }

    private Object createObject(Class<?> clazz) throws Exception {
        Constructor<?>[] constructors = clazz.getConstructors();
        Arrays.sort(constructors, COMPARATOR);
        block0: for (Constructor<?> c : constructors) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length == 0) {
                return c.newInstance(new Object[0]);
            }
            ArrayList<Object> parameters = new ArrayList<Object>(parameterTypes.length);
            for (Class<?> parameterType : parameterTypes) {
                Object param = this.container.getComponentInstanceOfType(parameterType);
                if (param == null) continue block0;
                parameters.add(param);
            }
            return c.newInstance(parameters.toArray(new Object[parameters.size()]));
        }
        return null;
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof GroovyScriptJarJarPlugin) {
            GroovyScriptJarJarPlugin jarjarPlugin = (GroovyScriptJarJarPlugin)plugin;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Add mapping to groovy instantiator:" + String.valueOf(jarjarPlugin.getMapping())));
            }
            this.mapping.putAll(jarjarPlugin.getMapping());
        }
    }

    private static class ConstructorsComparator
    implements Comparator<Constructor<?>> {
        private ConstructorsComparator() {
        }

        @Override
        public int compare(Constructor<?> constructor1, Constructor<?> constructor2) {
            int c2;
            int c1 = constructor1.getParameterTypes().length;
            if (c1 < (c2 = constructor2.getParameterTypes().length)) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return 0;
        }
    }
}

